/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundEditBookPacket
implements MinecraftPacket {
    private final int slot;
    private final List<String> pages;
    private final @Nullable String title;

    public ServerboundEditBookPacket(ByteBuf in) {
        this.slot = MinecraftTypes.readVarInt(in);
        this.pages = MinecraftTypes.readList(in, MinecraftTypes::readString);
        this.title = MinecraftTypes.readNullable(in, MinecraftTypes::readString);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.slot);
        MinecraftTypes.writeList(out, this.pages, MinecraftTypes::writeString);
        MinecraftTypes.writeNullable(out, this.title, MinecraftTypes::writeString);
    }

    public int getSlot() {
        return this.slot;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public @Nullable String getTitle() {
        return this.title;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundEditBookPacket)) {
            return false;
        }
        ServerboundEditBookPacket other = (ServerboundEditBookPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        List<String> this$pages = this.getPages();
        List<String> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundEditBookPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        List<String> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundEditBookPacket(slot=" + this.getSlot() + ", pages=" + String.valueOf(this.getPages()) + ", title=" + this.getTitle() + ")";
    }

    public @NonNull ServerboundEditBookPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundEditBookPacket(slot, this.pages, this.title);
    }

    public @NonNull ServerboundEditBookPacket withPages(List<String> pages) {
        return this.pages == pages ? this : new ServerboundEditBookPacket(this.slot, pages, this.title);
    }

    public @NonNull ServerboundEditBookPacket withTitle(@Nullable String title) {
        return this.title == title ? this : new ServerboundEditBookPacket(this.slot, this.pages, title);
    }

    public ServerboundEditBookPacket(int slot, List<String> pages, @Nullable String title) {
        this.slot = slot;
        this.pages = pages;
        this.title = title;
    }
}

