/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public class BiomeIdentifierRegistryLoader
implements RegistryLoader<String, Object2IntMap<String>> {
    @Override
    public Object2IntMap<String> load(String input) {
        Map<String, BiomeEntry> biomeEntries;
        TypeReference<Map<String, BiomeEntry>> biomeEntriesType = new TypeReference<Map<String, BiomeEntry>>(){};
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/biomes.json");){
            biomeEntries = GeyserImpl.JSON_MAPPER.readValue(stream, biomeEntriesType);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Bedrock runtime biomes", e);
        }
        Object2IntOpenHashMap<String> biomes = new Object2IntOpenHashMap<String>();
        for (Map.Entry<String, BiomeEntry> biome : biomeEntries.entrySet()) {
            biomes.put(biome.getKey(), biome.getValue().bedrockId);
        }
        return biomes;
    }

    private static class BiomeEntry {
        @JsonProperty(value="bedrock_id")
        private int bedrockId;

        private BiomeEntry() {
        }
    }
}

