/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension;

import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.extension.ExtensionLogger;

public class GeyserExtensionLogger
implements ExtensionLogger {
    private final GeyserLogger logger;
    private final String loggerPrefix;

    public GeyserExtensionLogger(GeyserLogger logger, String prefix) {
        this.logger = logger;
        this.loggerPrefix = prefix;
    }

    @Override
    public String prefix() {
        return this.loggerPrefix;
    }

    private String addPrefix(String message) {
        return "[" + this.loggerPrefix + "] " + message;
    }

    @Override
    public void severe(String message) {
        this.logger.severe(this.addPrefix(message));
    }

    @Override
    public void severe(String message, Throwable error) {
        this.logger.severe(this.addPrefix(message), error);
    }

    @Override
    public void error(String message) {
        this.logger.error(this.addPrefix(message));
    }

    @Override
    public void error(String message, Throwable error) {
        this.logger.error(this.addPrefix(message), error);
    }

    @Override
    public void warning(String message) {
        this.logger.warning(this.addPrefix(message));
    }

    @Override
    public void info(String message) {
        this.logger.info(this.addPrefix(message));
    }

    @Override
    public void debug(String message) {
        this.logger.debug(this.addPrefix(message));
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebug();
    }
}

