/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.exception.InvalidExtensionException;
import org.geysermc.geyser.extension.GeyserExtensionDescription;
import org.geysermc.geyser.extension.GeyserExtensionLoader;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

public class GeyserExtensionClassLoader
extends URLClassLoader {
    private final GeyserExtensionLoader loader;
    private final GeyserExtensionDescription description;
    private final Object2ObjectMap<String, Class<?>> classes = new Object2ObjectOpenHashMap();
    private boolean warnedForExternalClassAccess;

    public GeyserExtensionClassLoader(GeyserExtensionLoader loader, ClassLoader parent, Path path, GeyserExtensionDescription description) throws MalformedURLException {
        super(new URL[]{path.toUri().toURL()}, parent);
        this.loader = loader;
        this.description = description;
    }

    public Extension load() throws InvalidExtensionException {
        try {
            Class<Extension> extensionClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(this.description.main(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidExtensionException("Class " + this.description.main() + " not found, extension cannot be loaded", ex);
            }
            try {
                extensionClass = jarClass.asSubclass(Extension.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidExtensionException("Main class " + this.description.main() + " should implement Extension, but extends " + jarClass.getSuperclass().getSimpleName(), ex);
            }
            return extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new InvalidExtensionException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidExtensionException("Abnormal extension type", ex);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    protected Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.classes.get(name);
        if (result == null) {
            block6: {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException ignored) {
                    if (!checkGlobal) break block6;
                    if (!this.warnedForExternalClassAccess && this.description.dependencies().isEmpty()) {
                        GeyserImpl.getInstance().getLogger().warning("Extension " + this.description.name() + " loads class " + name + " from an external source. This can change at any time and break the extension, additionally to potentially causing unexpected behaviour!");
                        this.warnedForExternalClassAccess = true;
                    }
                    result = this.loader.classByName(name);
                }
            }
            if (result != null) {
                this.loader.setClass(name, result);
                this.classes.put(name, result);
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        return result;
    }
}

