/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl.modal;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.response.ModalFormResponse;

public final class ModalFormImpl
extends FormImpl<ModalFormResponse>
implements ModalForm {
    private final String content;
    private final String button1;
    private final String button2;

    public ModalFormImpl(@NonNull String title, @NonNull String content, @NonNull String button1, @NonNull String button2) {
        super(title);
        this.content = Objects.requireNonNull(content, "content");
        this.button1 = Objects.requireNonNull(button1, "button1");
        this.button2 = Objects.requireNonNull(button2, "button2");
    }

    @Override
    public @NonNull String content() {
        return this.content;
    }

    @Override
    public @NonNull String button1() {
        return this.button1;
    }

    @Override
    public @NonNull String button2() {
        return this.button2;
    }

    public static final class Builder
    extends FormImpl.Builder<ModalForm.Builder, ModalForm, ModalFormResponse>
    implements ModalForm.Builder {
        private String content = "";
        private String button1 = "";
        private String button2 = "";

        @Override
        public Builder content(@NonNull String content) {
            this.content = this.translate(Objects.requireNonNull(content, "content"));
            return this;
        }

        @Override
        public Builder button1(@NonNull String button1) {
            this.button1 = this.translate(Objects.requireNonNull(button1, "button1"));
            return this;
        }

        @Override
        public Builder button2(@NonNull String button2) {
            this.button2 = this.translate(Objects.requireNonNull(button2, "button2"));
            return this;
        }

        @Override
        public @NonNull ModalForm build() {
            ModalFormImpl form = new ModalFormImpl(this.title, this.content, this.button1, this.button2);
            this.setResponseHandler(form, form);
            return form;
        }
    }
}

