/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.VectorNd;
import org.cloudburstmc.math.vector.Vectord;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector3d
implements Vectord,
Comparable<Vector3d>,
Serializable,
Cloneable {
    public static final Vector3d ZERO = Vector3d.from(0.0f, 0.0f, 0.0f);
    public static final Vector3d UNIT_X = Vector3d.from(1.0f, 0.0f, 0.0f);
    public static final Vector3d UNIT_Y = Vector3d.from(0.0f, 1.0f, 0.0f);
    public static final Vector3d UNIT_Z = Vector3d.from(0.0f, 0.0f, 1.0f);
    public static final Vector3d ONE = Vector3d.from(1.0f, 1.0f, 1.0f);
    public static final Vector3d RIGHT = UNIT_X;
    public static final Vector3d UP = UNIT_Y;
    public static final Vector3d FORWARD = UNIT_Z;

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    public int getFloorZ() {
        return GenericMath.floor(this.getZ());
    }

    @Nonnull
    public Vector3d add(Vector3d v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d add(float x, float y, float z) {
        return this.add((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d add(double var1, double var3, double var5);

    @Nonnull
    public Vector3d sub(Vector3d v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d sub(float x, float y, float z) {
        return this.sub((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d sub(double var1, double var3, double var5);

    @Nonnull
    public Vector3d mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public Vector3d mul(double a) {
        return this.mul(a, a, a);
    }

    @Nonnull
    public Vector3d mul(Vector3d v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d mul(float x, float y, float z) {
        return this.mul((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d mul(double var1, double var3, double var5);

    @Nonnull
    public Vector3d div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public Vector3d div(double a) {
        return this.div(a, a, a);
    }

    @Nonnull
    public Vector3d div(Vector3d v) {
        return this.div(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d div(float x, float y, float z) {
        return this.div((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d div(double var1, double var3, double var5);

    public double dot(Vector3d v) {
        return this.dot(v.getX(), v.getY(), v.getZ());
    }

    public double dot(float x, float y, float z) {
        return this.dot((double)x, (double)y, (double)z);
    }

    public double dot(double x, double y, double z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    @Nonnull
    public Vector3d project(Vector3d v) {
        return this.project(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d project(float x, float y, float z) {
        return this.project((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d project(double var1, double var3, double var5);

    @Nonnull
    public Vector3d cross(Vector3d v) {
        return this.cross(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d cross(float x, float y, float z) {
        return this.cross((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d cross(double var1, double var3, double var5);

    @Nonnull
    public Vector3d pow(float pow) {
        return this.pow((double)pow);
    }

    @Override
    @Nonnull
    public abstract Vector3d pow(double var1);

    @Override
    @Nonnull
    public abstract Vector3d ceil();

    @Override
    @Nonnull
    public abstract Vector3d floor();

    @Override
    @Nonnull
    public abstract Vector3d round();

    @Override
    @Nonnull
    public abstract Vector3d abs();

    @Override
    @Nonnull
    public abstract Vector3d negate();

    @Nonnull
    public Vector3d min(Vector3d v) {
        return this.min(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d min(float x, float y, float z) {
        return this.min((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d min(double var1, double var3, double var5);

    @Nonnull
    public Vector3d max(Vector3d v) {
        return this.max(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d max(float x, float y, float z) {
        return this.max((double)x, (double)y, (double)z);
    }

    @Nonnull
    public abstract Vector3d max(double var1, double var3, double var5);

    public double distanceSquared(Vector3d v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ());
    }

    public double distanceSquared(float x, float y, float z) {
        return this.distanceSquared((double)x, (double)y, (double)z);
    }

    public double distanceSquared(double x, double y, double z) {
        double dx = this.getX() - x;
        double dy = this.getY() - y;
        double dz = this.getZ() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(Vector3d v) {
        return this.distance(v.getX(), v.getY(), v.getZ());
    }

    public double distance(float x, float y, float z) {
        return this.distance((double)x, (double)y, (double)z);
    }

    public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Nonnull
    public Vector3d up() {
        return this.up(1.0);
    }

    @Nonnull
    public abstract Vector3d up(double var1);

    @Nonnull
    public Vector3d down() {
        return this.down(1.0);
    }

    @Nonnull
    public abstract Vector3d down(double var1);

    @Nonnull
    public Vector3d north() {
        return this.north(1.0);
    }

    @Nonnull
    public abstract Vector3d north(double var1);

    @Nonnull
    public Vector3d south() {
        return this.south(1.0);
    }

    @Nonnull
    public abstract Vector3d south(double var1);

    @Nonnull
    public Vector3d east() {
        return this.east(1.0);
    }

    @Nonnull
    public abstract Vector3d east(double var1);

    @Nonnull
    public Vector3d west() {
        return this.west(1.0);
    }

    @Nonnull
    public abstract Vector3d west(double var1);

    @Override
    public double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector3d normalize();

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? (this.getX() < this.getZ() ? 0 : 2) : (this.getY() < this.getZ() ? 1 : 2);
    }

    @Override
    public int getMaxAxis() {
        return this.getX() < this.getY() ? (this.getY() < this.getZ() ? 2 : 1) : (this.getX() < this.getZ() ? 2 : 0);
    }

    @Nonnull
    public Vector2d toVector2() {
        return Vector2d.from(this);
    }

    @Nonnull
    public Vector2d toVector2(boolean useZ) {
        return Vector2d.from(this.getX(), useZ ? this.getZ() : this.getY());
    }

    @Nonnull
    public Vector4d toVector4() {
        return this.toVector4(0.0f);
    }

    @Nonnull
    public Vector4d toVector4(float w) {
        return this.toVector4((double)w);
    }

    @Nonnull
    public Vector4d toVector4(double w) {
        return Vector4d.from(this, w);
    }

    @Nonnull
    public VectorNd toVectorN() {
        return VectorNd.from(this);
    }

    @Override
    @Nonnull
    public double[] toArray() {
        return new double[]{this.getX(), this.getY(), this.getZ()};
    }

    @Override
    @Nonnull
    public Vector3i toInt() {
        return Vector3i.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3l toLong() {
        return Vector3l.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f toFloat() {
        return Vector3f.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d toDouble() {
        return Vector3d.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int compareTo(Vector3d v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector3d clone() {
        return Vector3d.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    @Nonnull
    public static Vector3d from(double n) {
        return Vectors.createVector3d(n, n, n);
    }

    @Nonnull
    public static Vector3d from(Vector2d v) {
        return Vector3d.from(v, 0.0f);
    }

    @Nonnull
    public static Vector3d from(Vector2d v, float z) {
        return Vector3d.from(v, (double)z);
    }

    @Nonnull
    public static Vector3d from(Vector2d v, double z) {
        return Vector3d.from(v.getX(), v.getY(), z);
    }

    @Nonnull
    public static Vector3d from(Vector3d v) {
        return Vector3d.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3d from(Vector4d v) {
        return Vector3d.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3d from(VectorNd v) {
        return Vector3d.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0.0);
    }

    @Nonnull
    public static Vector3d from(float x, float y, float z) {
        return Vector3d.from((double)x, (double)y, (double)z);
    }

    @Nonnull
    public static Vector3d from(double x, double y, double z) {
        return Vectors.createVector3d(x, y, z);
    }

    @Nonnull
    public static Vector3d createRandomDirection(Random random) {
        return Vector3d.createDirectionRad(random.nextDouble() * (Math.PI * 2), random.nextDouble() * (Math.PI * 2));
    }

    @Nonnull
    public static Vector3d createDirectionDeg(float theta, float phi) {
        return Vector3d.createDirectionDeg((double)theta, (double)phi);
    }

    @Nonnull
    public static Vector3d createDirectionDeg(double theta, double phi) {
        return Vector3d.createDirectionRad(Math.toRadians(theta), Math.toRadians(phi));
    }

    @Nonnull
    public static Vector3d createDirectionRad(float theta, float phi) {
        return Vector3d.createDirectionRad((double)theta, (double)phi);
    }

    @Nonnull
    public static Vector3d createDirectionRad(double theta, double phi) {
        double f = TrigMath.sin(phi);
        return Vector3d.from(f * (double)TrigMath.cos(theta), f * (double)TrigMath.sin(theta), (double)TrigMath.cos(phi));
    }
}

