/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;

public class ServerboundPlayerActionPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final PlayerAction action;
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final Direction face;
    private final int sequence;

    public ServerboundPlayerActionPacket(ByteBuf in) {
        this.action = PlayerAction.from(MinecraftTypes.readVarInt(in));
        this.position = MinecraftTypes.readPosition(in);
        this.face = Direction.VALUES[in.readUnsignedByte()];
        this.sequence = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.action.ordinal());
        MinecraftTypes.writePosition(out, this.position);
        out.writeByte(this.face.ordinal());
        MinecraftTypes.writeVarInt(out, this.sequence);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public PlayerAction getAction() {
        return this.action;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public Direction getFace() {
        return this.face;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerActionPacket)) {
            return false;
        }
        ServerboundPlayerActionPacket other = (ServerboundPlayerActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        PlayerAction this$action = this.getAction();
        PlayerAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Direction this$face = this.getFace();
        Direction other$face = other.getFace();
        return !(this$face == null ? other$face != null : !this$face.equals(other$face));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPlayerActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        PlayerAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Direction $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : $face.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPlayerActionPacket(action=" + String.valueOf((Object)this.getAction()) + ", position=" + String.valueOf(this.getPosition()) + ", face=" + String.valueOf(this.getFace()) + ", sequence=" + this.getSequence() + ")";
    }

    public @NonNull ServerboundPlayerActionPacket withAction(@lombok.NonNull PlayerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundPlayerActionPacket(action, this.position, this.face, this.sequence);
    }

    public @NonNull ServerboundPlayerActionPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundPlayerActionPacket(this.action, position, this.face, this.sequence);
    }

    public @NonNull ServerboundPlayerActionPacket withFace(@lombok.NonNull Direction face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ServerboundPlayerActionPacket(this.action, this.position, face, this.sequence);
    }

    public @NonNull ServerboundPlayerActionPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ServerboundPlayerActionPacket(this.action, this.position, this.face, sequence);
    }

    public ServerboundPlayerActionPacket(@lombok.NonNull PlayerAction action, @lombok.NonNull Vector3i position, @lombok.NonNull Direction face, int sequence) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        this.action = action;
        this.position = position;
        this.face = face;
        this.sequence = sequence;
    }
}

