/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.ArgumentSignature;

public class ServerboundChatCommandSignedPacket
implements MinecraftPacket {
    private final String command;
    private final long timeStamp;
    private final long salt;
    private final List<ArgumentSignature> signatures;
    private final int offset;
    private final BitSet acknowledgedMessages;
    private final byte checksum;

    public ServerboundChatCommandSignedPacket(ByteBuf in) {
        this.command = MinecraftTypes.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signatures = new ArrayList<ArgumentSignature>();
        int signatureCount = Math.min(MinecraftTypes.readVarInt(in), 8);
        for (int i = 0; i < signatureCount; ++i) {
            byte[] signature = new byte[256];
            this.signatures.add(new ArgumentSignature(MinecraftTypes.readString(in, 16), signature));
            in.readBytes(signature);
        }
        this.offset = MinecraftTypes.readVarInt(in);
        this.acknowledgedMessages = MinecraftTypes.readFixedBitSet(in, 20);
        this.checksum = in.readByte();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeString(out, this.command);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        MinecraftTypes.writeVarInt(out, this.signatures.size());
        for (ArgumentSignature signature : this.signatures) {
            MinecraftTypes.writeString(out, signature.getName());
            out.writeBytes(signature.getSignature());
        }
        MinecraftTypes.writeVarInt(out, this.offset);
        MinecraftTypes.writeFixedBitSet(out, this.acknowledgedMessages, 20);
        out.writeByte(this.checksum);
    }

    public String getCommand() {
        return this.command;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<ArgumentSignature> getSignatures() {
        return this.signatures;
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public byte getChecksum() {
        return this.checksum;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatCommandSignedPacket)) {
            return false;
        }
        ServerboundChatCommandSignedPacket other = (ServerboundChatCommandSignedPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getChecksum() != other.getChecksum()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        List<ArgumentSignature> this$signatures = this.getSignatures();
        List<ArgumentSignature> other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures)) {
            return false;
        }
        BitSet this$acknowledgedMessages = this.getAcknowledgedMessages();
        BitSet other$acknowledgedMessages = other.getAcknowledgedMessages();
        return !(this$acknowledgedMessages == null ? other$acknowledgedMessages != null : !((Object)this$acknowledgedMessages).equals(other$acknowledgedMessages));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChatCommandSignedPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getChecksum();
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        List<ArgumentSignature> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        BitSet $acknowledgedMessages = this.getAcknowledgedMessages();
        result = result * 59 + ($acknowledgedMessages == null ? 43 : ((Object)$acknowledgedMessages).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChatCommandSignedPacket(command=" + this.getCommand() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signatures=" + String.valueOf(this.getSignatures()) + ", offset=" + this.getOffset() + ", acknowledgedMessages=" + String.valueOf(this.getAcknowledgedMessages()) + ", checksum=" + this.getChecksum() + ")";
    }

    public @NonNull ServerboundChatCommandSignedPacket withCommand(String command) {
        return this.command == command ? this : new ServerboundChatCommandSignedPacket(command, this.timeStamp, this.salt, this.signatures, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatCommandSignedPacket(this.command, timeStamp, this.salt, this.signatures, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatCommandSignedPacket(this.command, this.timeStamp, salt, this.signatures, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withSignatures(List<ArgumentSignature> signatures) {
        return this.signatures == signatures ? this : new ServerboundChatCommandSignedPacket(this.command, this.timeStamp, this.salt, signatures, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withOffset(int offset) {
        return this.offset == offset ? this : new ServerboundChatCommandSignedPacket(this.command, this.timeStamp, this.salt, this.signatures, offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withAcknowledgedMessages(BitSet acknowledgedMessages) {
        return this.acknowledgedMessages == acknowledgedMessages ? this : new ServerboundChatCommandSignedPacket(this.command, this.timeStamp, this.salt, this.signatures, this.offset, acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatCommandSignedPacket withChecksum(byte checksum) {
        return this.checksum == checksum ? this : new ServerboundChatCommandSignedPacket(this.command, this.timeStamp, this.salt, this.signatures, this.offset, this.acknowledgedMessages, checksum);
    }

    public ServerboundChatCommandSignedPacket(String command, long timeStamp, long salt, List<ArgumentSignature> signatures, int offset, BitSet acknowledgedMessages, byte checksum) {
        this.command = command;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signatures = signatures;
        this.offset = offset;
        this.acknowledgedMessages = acknowledgedMessages;
        this.checksum = checksum;
    }
}

