/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundPlayerAbilitiesPacket
implements MinecraftPacket {
    private static final int FLAG_INVINCIBLE = 1;
    private static final int FLAG_FLYING = 2;
    private static final int FLAG_CAN_FLY = 4;
    private static final int FLAG_CREATIVE = 8;
    private final boolean invincible;
    private final boolean canFly;
    private final boolean flying;
    private final boolean creative;
    private final float flySpeed;
    private final float walkSpeed;

    public ClientboundPlayerAbilitiesPacket(ByteBuf in) {
        byte flags = in.readByte();
        this.invincible = (flags & 1) > 0;
        this.canFly = (flags & 4) > 0;
        this.flying = (flags & 2) > 0;
        this.creative = (flags & 8) > 0;
        this.flySpeed = in.readFloat();
        this.walkSpeed = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out) {
        int flags = 0;
        if (this.invincible) {
            flags |= 1;
        }
        if (this.canFly) {
            flags |= 4;
        }
        if (this.flying) {
            flags |= 2;
        }
        if (this.creative) {
            flags |= 8;
        }
        out.writeByte(flags);
        out.writeFloat(this.flySpeed);
        out.writeFloat(this.walkSpeed);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerAbilitiesPacket)) {
            return false;
        }
        ClientboundPlayerAbilitiesPacket other = (ClientboundPlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInvincible() != other.isInvincible()) {
            return false;
        }
        if (this.isCanFly() != other.isCanFly()) {
            return false;
        }
        if (this.isFlying() != other.isFlying()) {
            return false;
        }
        if (this.isCreative() != other.isCreative()) {
            return false;
        }
        if (Float.compare(this.getFlySpeed(), other.getFlySpeed()) != 0) {
            return false;
        }
        return Float.compare(this.getWalkSpeed(), other.getWalkSpeed()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerAbilitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInvincible() ? 79 : 97);
        result = result * 59 + (this.isCanFly() ? 79 : 97);
        result = result * 59 + (this.isFlying() ? 79 : 97);
        result = result * 59 + (this.isCreative() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getFlySpeed());
        result = result * 59 + Float.floatToIntBits(this.getWalkSpeed());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerAbilitiesPacket(invincible=" + this.isInvincible() + ", canFly=" + this.isCanFly() + ", flying=" + this.isFlying() + ", creative=" + this.isCreative() + ", flySpeed=" + this.getFlySpeed() + ", walkSpeed=" + this.getWalkSpeed() + ")";
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withInvincible(boolean invincible) {
        return this.invincible == invincible ? this : new ClientboundPlayerAbilitiesPacket(invincible, this.canFly, this.flying, this.creative, this.flySpeed, this.walkSpeed);
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withCanFly(boolean canFly) {
        return this.canFly == canFly ? this : new ClientboundPlayerAbilitiesPacket(this.invincible, canFly, this.flying, this.creative, this.flySpeed, this.walkSpeed);
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withFlying(boolean flying) {
        return this.flying == flying ? this : new ClientboundPlayerAbilitiesPacket(this.invincible, this.canFly, flying, this.creative, this.flySpeed, this.walkSpeed);
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withCreative(boolean creative) {
        return this.creative == creative ? this : new ClientboundPlayerAbilitiesPacket(this.invincible, this.canFly, this.flying, creative, this.flySpeed, this.walkSpeed);
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withFlySpeed(float flySpeed) {
        return this.flySpeed == flySpeed ? this : new ClientboundPlayerAbilitiesPacket(this.invincible, this.canFly, this.flying, this.creative, flySpeed, this.walkSpeed);
    }

    public @NonNull ClientboundPlayerAbilitiesPacket withWalkSpeed(float walkSpeed) {
        return this.walkSpeed == walkSpeed ? this : new ClientboundPlayerAbilitiesPacket(this.invincible, this.canFly, this.flying, this.creative, this.flySpeed, walkSpeed);
    }

    public ClientboundPlayerAbilitiesPacket(boolean invincible, boolean canFly, boolean flying, boolean creative, float flySpeed, float walkSpeed) {
        this.invincible = invincible;
        this.canFly = canFly;
        this.flying = flying;
        this.creative = creative;
        this.flySpeed = flySpeed;
        this.walkSpeed = walkSpeed;
    }
}

