/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundRotateHeadPacket
implements MinecraftPacket {
    private final int entityId;
    private final float headYaw;

    public ClientboundRotateHeadPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.headYaw = (float)(in.readByte() * 360) / 256.0f;
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        out.writeByte((byte)(this.headYaw * 256.0f / 360.0f));
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRotateHeadPacket)) {
            return false;
        }
        ClientboundRotateHeadPacket other = (ClientboundRotateHeadPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Float.compare(this.getHeadYaw(), other.getHeadYaw()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRotateHeadPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getHeadYaw());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRotateHeadPacket(entityId=" + this.getEntityId() + ", headYaw=" + this.getHeadYaw() + ")";
    }

    public @NonNull ClientboundRotateHeadPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundRotateHeadPacket(entityId, this.headYaw);
    }

    public @NonNull ClientboundRotateHeadPacket withHeadYaw(float headYaw) {
        return this.headYaw == headYaw ? this : new ClientboundRotateHeadPacket(this.entityId, headYaw);
    }

    public ClientboundRotateHeadPacket(int entityId, float headYaw) {
        this.entityId = entityId;
        this.headYaw = headYaw;
    }
}

