/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.KnownPack;

public class ServerboundSelectKnownPacks
implements MinecraftPacket {
    private final List<KnownPack> knownPacks;

    public ServerboundSelectKnownPacks(ByteBuf in) {
        this.knownPacks = new ArrayList<KnownPack>();
        int entryCount = Math.min(MinecraftTypes.readVarInt(in), 64);
        for (int i = 0; i < entryCount; ++i) {
            this.knownPacks.add(new KnownPack(MinecraftTypes.readString(in), MinecraftTypes.readString(in), MinecraftTypes.readString(in)));
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        if (this.knownPacks.size() > 64) {
            throw new IllegalArgumentException("KnownPacks is longer than maximum allowed length");
        }
        MinecraftTypes.writeVarInt(out, this.knownPacks.size());
        for (KnownPack entry : this.knownPacks) {
            MinecraftTypes.writeString(out, entry.getNamespace());
            MinecraftTypes.writeString(out, entry.getId());
            MinecraftTypes.writeString(out, entry.getVersion());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public List<KnownPack> getKnownPacks() {
        return this.knownPacks;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSelectKnownPacks)) {
            return false;
        }
        ServerboundSelectKnownPacks other = (ServerboundSelectKnownPacks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KnownPack> this$knownPacks = this.getKnownPacks();
        List<KnownPack> other$knownPacks = other.getKnownPacks();
        return !(this$knownPacks == null ? other$knownPacks != null : !((Object)this$knownPacks).equals(other$knownPacks));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSelectKnownPacks;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KnownPack> $knownPacks = this.getKnownPacks();
        result = result * 59 + ($knownPacks == null ? 43 : ((Object)$knownPacks).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSelectKnownPacks(knownPacks=" + String.valueOf(this.getKnownPacks()) + ")";
    }

    public @NonNull ServerboundSelectKnownPacks withKnownPacks(List<KnownPack> knownPacks) {
        return this.knownPacks == knownPacks ? this : new ServerboundSelectKnownPacks(knownPacks);
    }

    public ServerboundSelectKnownPacks(List<KnownPack> knownPacks) {
        this.knownPacks = knownPacks;
    }
}

