/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.serverbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.jetbrains.annotations.Nullable;

public class ServerboundCustomClickActionPacket
implements MinecraftPacket {
    private final Key id;
    @Nullable
    private final NbtMap payload;

    public ServerboundCustomClickActionPacket(ByteBuf in) {
        this.id = MinecraftTypes.readResourceLocation(in);
        this.payload = MinecraftTypes.readLengthPrefixed(in, 65536, buf -> {
            Object tag;
            if (!buf.readBoolean()) {
                return null;
            }
            try {
                ByteBufInputStream input = new ByteBufInputStream((ByteBuf)buf);
                int typeId = input.readUnsignedByte();
                if (typeId == 0) {
                    tag = null;
                } else {
                    NbtType<?> type = NbtType.byId(typeId);
                    tag = new NBTInputStream(input).readValue(type, 16);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (tag == null) {
                return null;
            }
            Class<NbtMap> tagClass = NbtType.COMPOUND.getTagClass();
            if (!tagClass.isInstance(tag)) {
                throw new IllegalArgumentException("Expected tag of type " + tagClass.getName() + " but got " + tag.getClass().getName());
            }
            return tagClass.cast(tag);
        });
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeResourceLocation(out, this.id);
        MinecraftTypes.writeLengthPrefixed(out, 65536, this.payload, (buf, data) -> {
            try {
                ByteBufOutputStream output = new ByteBufOutputStream((ByteBuf)buf);
                if (data == null) {
                    output.writeByte(0);
                    return;
                }
                NbtType<?> type = NbtType.byClass(data.getClass());
                output.writeByte(type.getId());
                new NBTOutputStream(output).writeValue(data, 16);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Key getId() {
        return this.id;
    }

    @Nullable
    public NbtMap getPayload() {
        return this.payload;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCustomClickActionPacket)) {
            return false;
        }
        ServerboundCustomClickActionPacket other = (ServerboundCustomClickActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$id = this.getId();
        Key other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        NbtMap this$payload = this.getPayload();
        NbtMap other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ServerboundCustomClickActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        NbtMap $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundCustomClickActionPacket(id=" + String.valueOf(this.getId()) + ", payload=" + String.valueOf(this.getPayload()) + ")";
    }

    public @NonNull ServerboundCustomClickActionPacket withId(Key id) {
        return this.id == id ? this : new ServerboundCustomClickActionPacket(id, this.payload);
    }

    public @NonNull ServerboundCustomClickActionPacket withPayload(@Nullable NbtMap payload) {
        return this.payload == payload ? this : new ServerboundCustomClickActionPacket(this.id, payload);
    }

    public ServerboundCustomClickActionPacket(Key id, @Nullable NbtMap payload) {
        this.id = id;
        this.payload = payload;
    }
}

