/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;

public class DataComponentType<T> {
    protected final int id;
    protected final Key key;
    protected final Reader<T> reader;
    protected final Writer<T> writer;
    protected final DataComponentFactory<T> dataComponentFactory;

    protected DataComponentType(int id, @KeyPattern String key, Reader<T> reader, Writer<T> writer, DataComponentFactory<T> dataComponentFactory) {
        this.id = id;
        this.key = Key.key(key);
        this.reader = reader;
        this.writer = writer;
        this.dataComponentFactory = dataComponentFactory;
    }

    public DataComponent<T, ? extends DataComponentType<T>> readDataComponent(ByteBuf input) {
        return this.dataComponentFactory.create(this, this.reader.read(input));
    }

    public DataComponent<T, ? extends DataComponentType<T>> readNullDataComponent() {
        return this.dataComponentFactory.create(this, null);
    }

    public void writeDataComponent(ByteBuf output, T value) {
        this.writer.write(output, value);
    }

    public String toString() {
        return "DataComponentType(id=" + this.id + " , key=" + this.key.asString() + ")";
    }

    public int getId() {
        return this.id;
    }

    public Key getKey() {
        return this.key;
    }

    public Reader<T> getReader() {
        return this.reader;
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public DataComponentFactory<T> getDataComponentFactory() {
        return this.dataComponentFactory;
    }

    @FunctionalInterface
    public static interface Reader<V> {
        public V read(ByteBuf var1);
    }

    @FunctionalInterface
    public static interface Writer<V> {
        public void write(ByteBuf var1, V var2);
    }

    @FunctionalInterface
    public static interface DataComponentFactory<V> {
        public DataComponent<V, ? extends DataComponentType<V>> create(DataComponentType<V> var1, V var2);
    }

    @FunctionalInterface
    public static interface BasicWriter<V>
    extends Writer<V> {
        @Override
        public void write(ByteBuf var1, V var2);
    }

    @FunctionalInterface
    public static interface BasicReader<V>
    extends Reader<V> {
        @Override
        public V read(ByteBuf var1);
    }
}

