/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import java.util.ArrayList;
import java.util.Set;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.KnownPack;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundSelectKnownPacks;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundSelectKnownPacks;

@Translator(packet=ClientboundSelectKnownPacks.class)
public class JavaSelectKnownPacksTranslator
extends PacketTranslator<ClientboundSelectKnownPacks> {
    private static final Set<String> KNOWN_PACK_IDS = Set.of("core", "trade_rebalance", "redstone_experiments", "minecart_improvements");

    @Override
    public void translate(GeyserSession session, ClientboundSelectKnownPacks packet) {
        ArrayList<KnownPack> knownPacks = new ArrayList<KnownPack>(1);
        for (KnownPack pack : packet.getKnownPacks()) {
            if (!"minecraft".equals(pack.getNamespace()) || !GameProtocol.getJavaMinecraftVersion().equals(pack.getVersion()) || !KNOWN_PACK_IDS.contains(pack.getId())) continue;
            knownPacks.add(pack);
        }
        session.sendDownstreamPacket(new ServerboundSelectKnownPacks(knownPacks));
    }
}

