/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.cloudburstmc.protocol.bedrock.packet.BookEditPacket;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Filterable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundEditBookPacket;

@Translator(packet=BookEditPacket.class)
public class BedrockBookEditTranslator
extends PacketTranslator<BookEditPacket> {
    @Override
    public void translate(GeyserSession session, BookEditPacket packet) {
        if (packet.getText() != null && !packet.getText().isEmpty() && packet.getText().length() > 1024) {
            session.getGeyser().getLogger().warning("Page length greater than server allowed!");
            return;
        }
        GeyserItemStack itemStack = session.getPlayerInventory().getItemInHand();
        if (itemStack != null) {
            String title;
            String currentPage;
            int page;
            DataComponents components = itemStack.getOrCreateComponents();
            ItemStack bookItem = new ItemStack(itemStack.getJavaId(), itemStack.getAmount(), components);
            LinkedList<String> pages = new LinkedList<String>();
            WritableBookContent writableBookContent = components.get(DataComponentTypes.WRITABLE_BOOK_CONTENT);
            if (writableBookContent != null) {
                for (Filterable<String> page2 : writableBookContent.getPages()) {
                    pages.add(page2.getRaw());
                }
            }
            if ((page = packet.getPageNumber()) < 0 || 100 <= page) {
                session.getGeyser().getLogger().warning("Edited page is out of acceptable bounds!");
                return;
            }
            switch (packet.getAction()) {
                case ADD_PAGE: {
                    for (int i = pages.size(); i < page; ++i) {
                        pages.add(i, "");
                    }
                    pages.add(page, MessageTranslator.convertToPlainText(packet.getText()));
                    break;
                }
                case REPLACE_PAGE: {
                    if (page < pages.size()) {
                        pages.set(page, MessageTranslator.convertToPlainText(packet.getText()));
                        break;
                    }
                    for (int i = pages.size(); i < page; ++i) {
                        pages.add(i, "");
                    }
                    pages.add(page, MessageTranslator.convertToPlainText(packet.getText()));
                    break;
                }
                case DELETE_PAGE: {
                    if (page >= pages.size()) break;
                    pages.remove(page);
                    break;
                }
                case SWAP_PAGES: {
                    int page2 = packet.getSecondaryPageNumber();
                    if (page >= pages.size() || page2 >= pages.size()) break;
                    Collections.swap(pages, page, page2);
                    break;
                }
                case SIGN_BOOK: {
                    break;
                }
                default: {
                    return;
                }
            }
            while (!pages.isEmpty() && (currentPage = (String)pages.get(pages.size() - 1)).isEmpty()) {
                pages.remove(pages.size() - 1);
            }
            ArrayList<Filterable<String>> filterablePages = new ArrayList<Filterable<String>>(pages.size());
            for (String raw : pages) {
                filterablePages.add(new Filterable<Object>(raw, null));
            }
            components.put(DataComponentTypes.WRITABLE_BOOK_CONTENT, new WritableBookContent(filterablePages));
            session.getPlayerInventory().setItem(36 + session.getPlayerInventory().getHeldItemSlot(), GeyserItemStack.from(bookItem), session);
            session.getPlayerInventoryHolder().updateInventory();
            if (packet.getAction() == BookEditPacket.Action.SIGN_BOOK) {
                title = MessageTranslator.convertToPlainText(packet.getTitle());
                if (title.length() > 16) {
                    session.getGeyser().getLogger().warning("Book title larger than server allows!");
                    return;
                }
            } else {
                title = null;
            }
            session.getBookEditCache().setPacket(new ServerboundEditBookPacket(session.getPlayerInventory().getHeldItemSlot(), pages, title));
            if (packet.getAction() == BookEditPacket.Action.SIGN_BOOK) {
                session.getBookEditCache().checkForSend();
            }
        }
    }
}

