/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.text.MinecraftLocale;

public class MinecraftTranslationRegistry
extends TranslatableComponentRenderer<String> {
    private final Pattern stringReplacement = Pattern.compile("%s");
    private final Pattern positionalStringReplacement = Pattern.compile("%([0-9]+)\\$s");
    private final Pattern escapeBraces = Pattern.compile("\\{+['{]+\\{+|\\{+");

    @Override
    public @Nullable MessageFormat translate(@NonNull String key, @NonNull String locale) {
        return this.translate(key, (String)null, locale);
    }

    @Override
    protected @Nullable MessageFormat translate(@NonNull String key, @Nullable String fallback, @NonNull String locale) {
        String localeString = MinecraftLocale.getLocaleStringIfPresent(key, locale);
        if (localeString == null) {
            if (fallback != null) {
                localeString = fallback;
            } else {
                return null;
            }
        }
        localeString = localeString.replace("'", "''");
        Pattern p = this.escapeBraces;
        Matcher m = p.matcher(localeString);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, "'" + m.group() + "'");
        }
        m.appendTail(sb);
        p = this.stringReplacement;
        m = p.matcher(sb.toString());
        sb = new StringBuilder();
        int i = 0;
        while (m.find()) {
            m.appendReplacement(sb, "{" + i++ + "}");
        }
        m.appendTail(sb);
        p = this.positionalStringReplacement;
        m = p.matcher(sb.toString());
        sb = new StringBuilder();
        while (m.find()) {
            i = Integer.parseInt(m.group(1)) - 1;
            m.appendReplacement(sb, "{" + i + "}");
        }
        m.appendTail(sb);
        return new MessageFormat(sb.toString(), Locale.ROOT);
    }
}

