/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.Dialog;
import org.geysermc.geyser.session.dialog.DialogButton;
import org.geysermc.geyser.session.dialog.DialogManager;
import org.geysermc.geyser.session.dialog.action.DialogAction;
import org.geysermc.geyser.session.dialog.input.ParsedInputs;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class DialogHolder {
    private final GeyserSession session;
    private final DialogManager manager;
    private final Dialog dialog;
    private long responseWaitTime = 0L;
    private boolean sendBackButton = false;
    private boolean shouldClose = false;
    private ParsedInputs lastInputs;

    public DialogHolder(GeyserSession session, DialogManager manager, Dialog dialog) {
        this.session = session;
        this.manager = manager;
        this.dialog = dialog;
    }

    public void runButton(Optional<DialogButton> button, @NonNull ParsedInputs inputs) {
        this.lastInputs = inputs;
        if (this.stillValid() && this.runAction(button, this.lastInputs)) {
            this.runAfterAction();
        }
    }

    public void tick() {
        if (this.responseWaitTime > 0L && !this.sendBackButton && System.currentTimeMillis() - this.responseWaitTime > 5000L) {
            this.sendBackButton = true;
            this.session.closeForm();
        }
    }

    public void closeDialog(Optional<DialogButton> onCancel) {
        if (!this.stillValid()) {
            return;
        }
        if (this.dialog.canCloseWithEscape()) {
            this.shouldClose = true;
            if (this.runAction(onCancel, this.lastInputs == null ? this.dialog.defaultInputs() : this.lastInputs)) {
                this.manager.close();
            }
            return;
        }
        this.reopenDialog();
    }

    private void reopenDialog() {
        if (this.stillValid()) {
            if (this.shouldClose) {
                this.manager.close();
            } else {
                this.responseWaitTime = 0L;
                if (this.lastInputs == null) {
                    this.dialog.sendForm(this);
                } else {
                    this.dialog.restoreForm(this, this.lastInputs);
                }
            }
        }
    }

    private void runAfterAction() {
        switch (this.dialog.afterAction()) {
            case NONE: {
                this.dialog.restoreForm(this, this.lastInputs);
                break;
            }
            case CLOSE: {
                this.manager.close();
                break;
            }
            case WAIT_FOR_RESPONSE: {
                this.responseWaitTime = System.currentTimeMillis();
                this.sendBackButton = false;
                this.waitForResponse();
            }
        }
    }

    private void waitForResponse() {
        String content = this.sendBackButton ? GeyserLocale.getPlayerLocaleString("geyser.dialogs.waiting_for_a_while", this.session.locale()) : GeyserLocale.getPlayerLocaleString("geyser.dialogs.waiting_for_response", this.session.locale());
        this.session.sendDialogForm((Form)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(MinecraftLocale::getLocaleString, this.session.locale())).title("gui.waitingForResponse.title")).content(content).optionalButton("gui.back", this.sendBackButton).closedOrInvalidResultHandler(() -> {
            if (this.stillValid()) {
                this.waitForResponse();
            }
        })).validResultHandler(response -> this.manager.close())).build());
    }

    private boolean runAction(Optional<DialogButton> button, @NonNull ParsedInputs inputs) {
        DialogAction action = button.flatMap(DialogButton::action).orElse(null);
        if (action != null) {
            if (action instanceof DialogAction.CommandAction) {
                DialogAction.CommandAction runCommand = (DialogAction.CommandAction)action;
                String command = runCommand.trimmedCommand(this.session, inputs);
                String root = command.split(" ")[0];
                if (this.session.getRestrictedCommands().contains(root)) {
                    this.showCommandConfirmation(command, false);
                    return false;
                }
                if (!this.session.getKnownCommands().contains(root)) {
                    this.showCommandConfirmation(command, true);
                    return false;
                }
                this.session.sendCommand(command);
                return true;
            }
            if (action instanceof DialogAction.OpenUrl) {
                DialogAction.OpenUrl openUrl = (DialogAction.OpenUrl)action;
                this.showUrl(openUrl.url());
                return false;
            }
            action.run(this.session, inputs);
            return !(action instanceof DialogAction.ShowDialog);
        }
        return true;
    }

    private void showCommandConfirmation(String trimmedCommand, boolean unknown) {
        TranslatableComponent content = Component.translatable(unknown ? "multiplayer.confirm_command.parse_errors" : "multiplayer.confirm_command.permissions_required", Component.text(trimmedCommand).color(NamedTextColor.YELLOW));
        this.session.sendDialogForm((Form)((ModalForm.Builder)((ModalForm.Builder)((ModalForm.Builder)((ModalForm.Builder)ModalForm.builder().translator(MinecraftLocale::getLocaleString, this.session.locale())).title("multiplayer.confirm_command.title")).content(MessageTranslator.convertMessage(this.session, content)).button1("gui.yes").button2("gui.no").closedOrInvalidResultHandler(() -> {
            this.shouldClose = false;
            this.reopenDialog();
        })).validResultHandler(response -> {
            if (response.clickedFirst()) {
                this.session.sendCommand(trimmedCommand);
                if (this.shouldClose) {
                    this.manager.close();
                } else {
                    this.runAfterAction();
                }
            } else {
                this.shouldClose = false;
                this.reopenDialog();
            }
        })).build());
    }

    private void showUrl(String url) {
        String content = MessageTranslator.convertMessage(this.session, ((TextComponent)((TextComponent)((TextComponent)Component.text(GeyserLocale.getPlayerLocaleString("geyser.dialogs.open_url", this.session.locale())).append(Component.text("\n\n"))).append(Component.text(url))).append(Component.text("\n\n"))).append(Component.translatable("chat.link.warning").color(NamedTextColor.RED)));
        this.session.sendDialogForm((Form)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(MinecraftLocale::getLocaleString, this.session.locale())).title("chat.link.open")).content(content).button("gui.ok").resultHandler((form, result) -> {
            if (this.stillValid()) {
                if (this.shouldClose) {
                    this.manager.close();
                } else {
                    this.runAfterAction();
                }
            }
        })).build());
    }

    private boolean stillValid() {
        return this.manager.open() == this;
    }

    public GeyserSession session() {
        return this.session;
    }
}

