/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.util.MinecraftKey;

public record UtilMappings(List<Key> gameMasterBlocks, List<Key> dangerousBlockEntities, List<Key> dangerousEntities) {
    private static final String INPUT = "mappings/util.json";
    private static UtilMappings loaded = null;

    private static UtilMappings get() {
        if (loaded == null) {
            try (InputStream utilInput = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(INPUT);){
                JsonObject utilJson = new JsonParser().parse(new InputStreamReader(utilInput)).getAsJsonObject();
                ArrayList gameMasterBlocks = new ArrayList();
                ArrayList dangerousBlockEntities = new ArrayList();
                ArrayList dangerousEntities = new ArrayList();
                utilJson.get("game_master_blocks").getAsJsonArray().forEach(element -> gameMasterBlocks.add(MinecraftKey.key(element.getAsString())));
                utilJson.get("dangerous_block_entities").getAsJsonArray().forEach(element -> dangerousBlockEntities.add(MinecraftKey.key(element.getAsString())));
                utilJson.get("dangerous_entities").getAsJsonArray().forEach(element -> dangerousEntities.add(MinecraftKey.key(element.getAsString())));
                loaded = new UtilMappings(List.copyOf(gameMasterBlocks), List.copyOf(dangerousBlockEntities), List.copyOf(dangerousEntities));
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to load mappings/util.json");
            }
        }
        return loaded;
    }

    public static class Loader<T>
    implements RegistryLoader<Function<UtilMappings, T>, T> {
        @Override
        public T load(Function<UtilMappings, T> input) {
            return input.apply(UtilMappings.get());
        }
    }
}

