/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.event.type.GeyserDefineCustomItemsEventImpl;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.components.WearableSlot;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.mappings.MappingsConfigReader;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class CustomItemRegistryPopulator {
    public static void populate(final Map<String, GeyserMappingItem> items, final Multimap<String, CustomItemData> customItems, final List<NonVanillaCustomItemData> nonVanillaCustomItems) {
        MappingsConfigReader mappingsConfigReader = new MappingsConfigReader();
        mappingsConfigReader.loadItemMappingsFromJson((key, item) -> {
            if (CustomItemRegistryPopulator.initialCheck(key, item, items)) {
                customItems.get((String)key).add(item);
            }
        });
        GeyserImpl.getInstance().eventBus().fire(new GeyserDefineCustomItemsEventImpl(customItems, nonVanillaCustomItems){

            @Override
            public boolean register(@NonNull String identifier, @NonNull CustomItemData customItemData) {
                if (CustomItemRegistryPopulator.initialCheck(identifier, customItemData, items)) {
                    customItems.get(identifier).add(customItemData);
                    return true;
                }
                return false;
            }

            @Override
            public boolean register(@NonNull NonVanillaCustomItemData customItemData) {
                if (customItemData.identifier().startsWith("minecraft:")) {
                    GeyserImpl.getInstance().getLogger().error("The custom item " + customItemData.identifier() + " is attempting to masquerade as a vanilla Minecraft item!");
                    return false;
                }
                if (customItemData.javaId() < items.size()) {
                    GeyserImpl.getInstance().getLogger().error("The custom item " + customItemData.identifier() + " is attempting to overwrite a vanilla Minecraft item!");
                    return false;
                }
                nonVanillaCustomItems.add(customItemData);
                return true;
            }
        });
        int customItemCount = customItems.size() + nonVanillaCustomItems.size();
        if (customItemCount > 0) {
            GeyserImpl.getInstance().getLogger().info("Registered " + customItemCount + " custom items");
        }
    }

    public static GeyserCustomMappingData registerCustomItem(String customItemName, Item javaItem, GeyserMappingItem mapping, CustomItemData customItemData, int bedrockId, int protocolVersion) {
        NbtMapBuilder builder = CustomItemRegistryPopulator.createComponentNbt(customItemData, javaItem, mapping, customItemName, bedrockId, protocolVersion);
        SimpleItemDefinition itemDefinition = new SimpleItemDefinition(customItemName, bedrockId, ItemVersion.DATA_DRIVEN, true, builder.build());
        return new GeyserCustomMappingData(itemDefinition, customItemName, bedrockId);
    }

    static boolean initialCheck(String identifier, CustomItemData item, Map<String, GeyserMappingItem> mappings) {
        String name;
        if (!mappings.containsKey(identifier)) {
            GeyserImpl.getInstance().getLogger().error("Could not find the Java item to add custom item properties to for " + item.name());
            return false;
        }
        if (!item.customItemOptions().hasCustomItemOptions()) {
            GeyserImpl.getInstance().getLogger().error("The custom item " + item.name() + " has no registration types");
        }
        if ((name = item.name()).isEmpty()) {
            GeyserImpl.getInstance().getLogger().warning("Custom item name is empty?");
        } else if (Character.isDigit(name.charAt(0))) {
            GeyserImpl.getInstance().getLogger().warning("Custom item name (" + name + ") begins with a digit. This may cause issues!");
        }
        return true;
    }

    public static NonVanillaItemRegistration registerCustomItem(NonVanillaCustomItemData customItemData, int customItemId, int protocolVersion) {
        String customIdentifier = customItemData.identifier();
        DataComponents components = new DataComponents(new HashMap());
        components.put(DataComponentTypes.MAX_STACK_SIZE, customItemData.stackSize());
        components.put(DataComponentTypes.MAX_DAMAGE, customItemData.maxDamage());
        Item item = new Item(customIdentifier, Item.builder().components(components));
        Items.register(item, customItemData.javaId());
        NbtMapBuilder builder = CustomItemRegistryPopulator.createComponentNbt(customItemData, customItemData.identifier(), customItemId, customItemData.isHat(), customItemData.displayHandheld(), protocolVersion);
        ItemMapping customItemMapping = ItemMapping.builder().bedrockIdentifier(customIdentifier).bedrockDefinition(new SimpleItemDefinition(customIdentifier, customItemId, ItemVersion.DATA_DRIVEN, true, builder.build())).bedrockData(0).bedrockBlockDefinition(null).toolType(customItemData.toolType()).translationString(customItemData.translationString()).customItemOptions(Collections.emptyList()).javaItem(item).build();
        return new NonVanillaItemRegistration(item, customItemMapping);
    }

    private static NbtMapBuilder createComponentNbt(CustomItemData customItemData, Item javaItem, GeyserMappingItem mapping, String customItemName, int customItemId, int protocolVersion) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", customItemName).putInt("id", customItemId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        CustomItemRegistryPopulator.setupBasicItemInfo(javaItem.defaultMaxDamage(), javaItem.defaultMaxStackSize(), mapping.getToolType() != null || customItemData.displayHandheld(), customItemData, itemProperties, componentBuilder, protocolVersion);
        boolean canDestroyInCreative = true;
        if (mapping.getToolType() != null) {
            canDestroyInCreative = CustomItemRegistryPopulator.computeToolProperties(mapping.getToolType(), itemProperties, componentBuilder, javaItem.defaultAttackDamage());
        }
        itemProperties.putBoolean("can_destroy_in_creative", canDestroyInCreative);
        if (mapping.getArmorType() != null) {
            CustomItemRegistryPopulator.computeArmorProperties(mapping.getArmorType(), mapping.getProtectionValue(), itemProperties, componentBuilder);
        }
        if (mapping.getFirstBlockRuntimeId() != null) {
            CustomItemRegistryPopulator.computeBlockItemProperties(mapping.getBedrockIdentifier(), componentBuilder);
        }
        if (mapping.isEdible()) {
            CustomItemRegistryPopulator.computeConsumableProperties(itemProperties, componentBuilder, 1, false);
        }
        if (mapping.isEntityPlacer()) {
            CustomItemRegistryPopulator.computeEntityPlacerProperties(componentBuilder);
        }
        switch (mapping.getBedrockIdentifier()) {
            case "minecraft:fire_charge": 
            case "minecraft:flint_and_steel": {
                CustomItemRegistryPopulator.computeBlockItemProperties("minecraft:fire", componentBuilder);
                break;
            }
            case "minecraft:bow": 
            case "minecraft:crossbow": 
            case "minecraft:trident": {
                CustomItemRegistryPopulator.computeChargeableProperties(itemProperties, componentBuilder, mapping.getBedrockIdentifier(), protocolVersion);
                break;
            }
            case "minecraft:honey_bottle": 
            case "minecraft:milk_bucket": 
            case "minecraft:potion": {
                CustomItemRegistryPopulator.computeConsumableProperties(itemProperties, componentBuilder, 2, true);
                break;
            }
            case "minecraft:experience_bottle": 
            case "minecraft:egg": 
            case "minecraft:ender_pearl": 
            case "minecraft:ender_eye": 
            case "minecraft:lingering_potion": 
            case "minecraft:snowball": 
            case "minecraft:splash_potion": {
                CustomItemRegistryPopulator.computeThrowableProperties(componentBuilder);
            }
        }
        boolean isHat = javaItem.equals(Items.SKELETON_SKULL) || javaItem.equals(Items.WITHER_SKELETON_SKULL) || javaItem.equals(Items.CARVED_PUMPKIN) || javaItem.equals(Items.ZOMBIE_HEAD) || javaItem.equals(Items.PIGLIN_HEAD) || javaItem.equals(Items.DRAGON_HEAD) || javaItem.equals(Items.CREEPER_HEAD) || javaItem.equals(Items.PLAYER_HEAD);
        CustomItemRegistryPopulator.computeRenderOffsets(isHat, customItemData, componentBuilder);
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder;
    }

    private static NbtMapBuilder createComponentNbt(NonVanillaCustomItemData customItemData, String customItemName, int customItemId, boolean isHat, boolean displayHandheld, int protocolVersion) {
        String block;
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", customItemName).putInt("id", customItemId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        CustomItemRegistryPopulator.setupBasicItemInfo(customItemData.maxDamage(), customItemData.stackSize(), displayHandheld, customItemData, itemProperties, componentBuilder, protocolVersion);
        boolean canDestroyInCreative = true;
        if (customItemData.toolType() != null) {
            canDestroyInCreative = CustomItemRegistryPopulator.computeToolProperties(Objects.requireNonNull(customItemData.toolType()), itemProperties, componentBuilder, customItemData.attackDamage());
        }
        itemProperties.putBoolean("can_destroy_in_creative", canDestroyInCreative);
        String armorType = customItemData.armorType();
        if (armorType != null) {
            CustomItemRegistryPopulator.computeArmorProperties(armorType, customItemData.protectionValue(), itemProperties, componentBuilder);
        }
        if (customItemData.isEdible()) {
            CustomItemRegistryPopulator.computeConsumableProperties(itemProperties, componentBuilder, 1, customItemData.canAlwaysEat());
        }
        if (customItemData.isChargeable()) {
            String tooltype = customItemData.toolType();
            if (tooltype == null) {
                throw new IllegalArgumentException("tool type must be set if the custom item is chargeable!");
            }
            CustomItemRegistryPopulator.computeChargeableProperties(itemProperties, componentBuilder, "minecraft:" + tooltype, protocolVersion);
        }
        CustomItemRegistryPopulator.computeRenderOffsets(isHat, customItemData, componentBuilder);
        if (customItemData.isFoil()) {
            itemProperties.putBoolean("foil", true);
        }
        if ((block = customItemData.block()) != null) {
            CustomItemRegistryPopulator.computeBlockItemProperties(block, componentBuilder);
        }
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder;
    }

    private static void setupBasicItemInfo(int maxDamage, int stackSize, boolean displayHandheld, CustomItemData customItemData, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, int protocolVersion) {
        NbtMap iconMap = NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", customItemData.icon()).build()).build();
        itemProperties.putCompound("minecraft:icon", iconMap);
        if (customItemData.creativeCategory().isPresent()) {
            itemProperties.putInt("creative_category", customItemData.creativeCategory().getAsInt());
            if (customItemData.creativeGroup() != null) {
                itemProperties.putString("creative_group", customItemData.creativeGroup());
            }
        }
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", customItemData.displayName()).build());
        CustomItemRegistryPopulator.addItemTag(componentBuilder, "geyser:is_custom");
        Set<String> tags = customItemData.tags();
        for (String tag : tags) {
            if (tag == null || tag.isBlank()) continue;
            CustomItemRegistryPopulator.addItemTag(componentBuilder, tag);
        }
        itemProperties.putBoolean("allow_off_hand", customItemData.allowOffhand());
        itemProperties.putBoolean("hand_equipped", displayHandheld);
        itemProperties.putInt("max_stack_size", stackSize);
        if (maxDamage > 0 && customItemData.customItemOptions().unbreakable() != TriState.TRUE) {
            componentBuilder.putCompound("minecraft:durability", NbtMap.builder().putCompound("damage_chance", NbtMap.builder().putInt("max", 1).putInt("min", 1).build()).putInt("max_durability", maxDamage).build());
            itemProperties.putBoolean("use_duration", true);
        }
    }

    private static boolean computeToolProperties(String toolType, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, int attackDamage) {
        boolean canDestroyInCreative = true;
        float miningSpeed = 1.0f;
        ArrayList<NbtMap> speed = new ArrayList<NbtMap>(List.of(NbtMap.builder().putCompound("block", NbtMap.builder().putString("tags", "1").build()).putCompound("on_dig", NbtMap.builder().putCompound("condition", NbtMap.builder().putString("expression", "").putInt("version", -1).build()).putString("event", "tool_durability").putString("target", "self").build()).putInt("speed", 0).build()));
        componentBuilder.putCompound("minecraft:digger", NbtMap.builder().putList("destroy_speeds", NbtType.COMPOUND, speed).putCompound("on_dig", NbtMap.builder().putCompound("condition", NbtMap.builder().putString("expression", "").putInt("version", -1).build()).putString("event", "tool_durability").putString("target", "self").build()).putBoolean("use_efficiency", false).build());
        if (toolType.equals("sword")) {
            miningSpeed = 1.5f;
            canDestroyInCreative = false;
        }
        itemProperties.putBoolean("hand_equipped", true);
        itemProperties.putFloat("mining_speed", miningSpeed);
        itemProperties.putInt("enchantable_value", 1);
        itemProperties.putString("enchantable_slot", toolType);
        if (attackDamage > 0) {
            itemProperties.putInt("damage", attackDamage);
        }
        return canDestroyInCreative;
    }

    private static void computeArmorProperties(String armorType, int protectionValue, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        switch (armorType) {
            case "boots": {
                componentBuilder.putString("minecraft:render_offsets", "boots");
                componentBuilder.putCompound("minecraft:wearable", WearableSlot.FEET.getSlotNbt());
                componentBuilder.putCompound("minecraft:armor", NbtMap.builder().putInt("protection", protectionValue).build());
                itemProperties.putString("enchantable_slot", "armor_feet");
                itemProperties.putInt("enchantable_value", 15);
                break;
            }
            case "chestplate": {
                componentBuilder.putString("minecraft:render_offsets", "chestplates");
                componentBuilder.putCompound("minecraft:wearable", WearableSlot.CHEST.getSlotNbt());
                componentBuilder.putCompound("minecraft:armor", NbtMap.builder().putInt("protection", protectionValue).build());
                itemProperties.putString("enchantable_slot", "armor_torso");
                itemProperties.putInt("enchantable_value", 15);
                break;
            }
            case "leggings": {
                componentBuilder.putString("minecraft:render_offsets", "leggings");
                componentBuilder.putCompound("minecraft:wearable", WearableSlot.LEGS.getSlotNbt());
                componentBuilder.putCompound("minecraft:armor", NbtMap.builder().putInt("protection", protectionValue).build());
                itemProperties.putString("enchantable_slot", "armor_legs");
                itemProperties.putInt("enchantable_value", 15);
                break;
            }
            case "helmet": {
                componentBuilder.putString("minecraft:render_offsets", "helmets");
                componentBuilder.putCompound("minecraft:wearable", WearableSlot.HEAD.getSlotNbt());
                componentBuilder.putCompound("minecraft:armor", NbtMap.builder().putInt("protection", protectionValue).build());
                itemProperties.putString("enchantable_slot", "armor_head");
                itemProperties.putInt("enchantable_value", 15);
            }
        }
    }

    private static void computeBlockItemProperties(String blockItem, NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:block_placer", NbtMap.builder().putString("block", blockItem).build());
    }

    private static void computeChargeableProperties(NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, String mapping, int protocolVersion) {
        itemProperties.putInt("use_duration", Integer.MAX_VALUE);
        itemProperties.putBoolean("hand_equipped", true);
        itemProperties.putInt("enchantable_value", 1);
        componentBuilder.putCompound("minecraft:use_modifiers", NbtMap.builder().putFloat("use_duration", 100.0f).putFloat("movement_modifier", 0.35f).build());
        switch (mapping) {
            case "minecraft:bow": {
                itemProperties.putString("enchantable_slot", "bow");
                itemProperties.putInt("frame_count", 3);
                componentBuilder.putCompound("minecraft:shooter", NbtMap.builder().putList("ammunition", NbtType.COMPOUND, List.of(NbtMap.builder().putCompound("item", NbtMap.builder().putString("name", "minecraft:arrow").build()).putBoolean("use_offhand", true).putBoolean("search_inventory", true).build())).putFloat("max_draw_duration", 0.0f).putBoolean("charge_on_draw", true).putBoolean("scale_power_by_draw_duration", true).build());
                componentBuilder.putInt("minecraft:use_duration", 999);
                break;
            }
            case "minecraft:trident": {
                itemProperties.putString("enchantable_slot", "trident");
                componentBuilder.putInt("minecraft:use_duration", 999);
                break;
            }
            case "minecraft:crossbow": {
                itemProperties.putString("enchantable_slot", "crossbow");
                itemProperties.putInt("frame_count", 10);
                componentBuilder.putCompound("minecraft:shooter", NbtMap.builder().putList("ammunition", NbtType.COMPOUND, List.of(NbtMap.builder().putCompound("item", NbtMap.builder().putString("name", "minecraft:arrow").build()).putBoolean("use_offhand", true).putBoolean("search_inventory", true).build())).putFloat("max_draw_duration", 1.0f).putBoolean("charge_on_draw", true).putBoolean("scale_power_by_draw_duration", true).build());
                componentBuilder.putInt("minecraft:use_duration", 999);
            }
        }
    }

    private static void computeConsumableProperties(NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, int useAnimation, boolean canAlwaysEat) {
        itemProperties.putInt("use_duration", 32);
        itemProperties.putInt("use_animation", useAnimation);
        componentBuilder.putCompound("minecraft:food", NbtMap.builder().putBoolean("can_always_eat", canAlwaysEat).build());
    }

    private static void computeEntityPlacerProperties(NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putString("entity", "minecraft:minecart").build());
    }

    private static void computeThrowableProperties(NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:throwable", NbtMap.builder().putBoolean("do_swing_animation", true).build());
        componentBuilder.putCompound("minecraft:projectile", NbtMap.builder().putString("projectile_entity", "minecraft:snowball").build());
    }

    private static void computeRenderOffsets(boolean isHat, CustomItemData customItemData, NbtMapBuilder componentBuilder) {
        CustomRenderOffsets renderOffsets;
        if (isHat) {
            componentBuilder.remove("minecraft:render_offsets");
            componentBuilder.putString("minecraft:render_offsets", "helmets");
            componentBuilder.remove("minecraft:wearable");
            componentBuilder.putCompound("minecraft:wearable", WearableSlot.HEAD.getSlotNbt());
        }
        if ((renderOffsets = customItemData.renderOffsets()) != null) {
            componentBuilder.remove("minecraft:render_offsets");
            componentBuilder.putCompound("minecraft:render_offsets", CustomItemRegistryPopulator.toNbtMap(renderOffsets));
        } else if (customItemData.textureSize() != 16 && !componentBuilder.containsKey("minecraft:render_offsets")) {
            float scale1 = (float)(0.075 / (double)((float)customItemData.textureSize() / 16.0f));
            float scale2 = (float)(0.125 / (double)((float)customItemData.textureSize() / 16.0f));
            float scale3 = (float)(0.075 / (double)((float)customItemData.textureSize() / 16.0f * 2.4f));
            componentBuilder.putCompound("minecraft:render_offsets", NbtMap.builder().putCompound("main_hand", NbtMap.builder().putCompound("first_person", CustomItemRegistryPopulator.xyzToScaleList(scale3, scale3, scale3)).putCompound("third_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).build()).putCompound("off_hand", NbtMap.builder().putCompound("first_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).putCompound("third_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).build()).build());
        }
    }

    private static NbtMap toNbtMap(CustomRenderOffsets renderOffsets) {
        NbtMap nbt;
        CustomRenderOffsets.Hand offhand;
        NbtMap nbt2;
        NbtMapBuilder builder = NbtMap.builder();
        CustomRenderOffsets.Hand mainHand = renderOffsets.mainHand();
        if (mainHand != null && (nbt2 = CustomItemRegistryPopulator.toNbtMap(mainHand)) != null) {
            builder.putCompound("main_hand", nbt2);
        }
        if ((offhand = renderOffsets.offhand()) != null && (nbt = CustomItemRegistryPopulator.toNbtMap(offhand)) != null) {
            builder.putCompound("off_hand", nbt);
        }
        return builder.build();
    }

    private static @Nullable NbtMap toNbtMap(CustomRenderOffsets.Hand hand) {
        NbtMap firstPerson = CustomItemRegistryPopulator.toNbtMap(hand.firstPerson());
        NbtMap thirdPerson = CustomItemRegistryPopulator.toNbtMap(hand.thirdPerson());
        if (firstPerson == null && thirdPerson == null) {
            return null;
        }
        NbtMapBuilder builder = NbtMap.builder();
        if (firstPerson != null) {
            builder.putCompound("first_person", firstPerson);
        }
        if (thirdPerson != null) {
            builder.putCompound("third_person", thirdPerson);
        }
        return builder.build();
    }

    private static @Nullable NbtMap toNbtMap(@Nullable CustomRenderOffsets.Offset offset) {
        if (offset == null) {
            return null;
        }
        CustomRenderOffsets.OffsetXYZ position = offset.position();
        CustomRenderOffsets.OffsetXYZ rotation = offset.rotation();
        CustomRenderOffsets.OffsetXYZ scale = offset.scale();
        if (position == null && rotation == null && scale == null) {
            return null;
        }
        NbtMapBuilder builder = NbtMap.builder();
        if (position != null) {
            builder.putList("position", NbtType.FLOAT, CustomItemRegistryPopulator.toList(position));
        }
        if (rotation != null) {
            builder.putList("rotation", NbtType.FLOAT, CustomItemRegistryPopulator.toList(rotation));
        }
        if (scale != null) {
            builder.putList("scale", NbtType.FLOAT, CustomItemRegistryPopulator.toList(scale));
        }
        return builder.build();
    }

    private static List<Float> toList(CustomRenderOffsets.OffsetXYZ xyz) {
        return List.of(Float.valueOf(xyz.x()), Float.valueOf(xyz.y()), Float.valueOf(xyz.z()));
    }

    private static void addItemTag(NbtMapBuilder builder, String tag) {
        ArrayList<String> tagList = (ArrayList<String>)builder.get("item_tags");
        if (tagList == null) {
            builder.putList("item_tags", NbtType.STRING, tag);
        } else if (!tagList.contains(tag)) {
            tagList = new ArrayList<String>(tagList);
            tagList.add(tag);
            builder.putList("item_tags", NbtType.STRING, tagList);
        }
    }

    private static NbtMap xyzToScaleList(float x, float y, float z) {
        return NbtMap.builder().putList("scale", NbtType.FLOAT, List.of(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z))).build();
    }
}

