/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;

public final class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int padding = 10;
    private static final int labelPadding = 25;
    private static final int pointWidth = 4;
    private static final int numberYDivisions = 10;
    private static final Color lineColor = new Color(44, 102, 230, 255);
    private static final Color pointColor = new Color(100, 100, 100, 255);
    private static final Color gridColor = new Color(200, 200, 200, 255);
    private static final Stroke graphStroke = new BasicStroke(2.0f);
    private final List<Integer> values = new ArrayList<Integer>(10);
    private String xLabel = "";

    public GraphPanel() {
        this.setPreferredSize(new Dimension(180, 130));
    }

    public void setValues(Collection<Integer> newValues) {
        this.values.clear();
        this.addValues(newValues);
    }

    public void addValues(Collection<Integer> newValues) {
        this.values.addAll(newValues);
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean drawDots;
        int y1;
        int x1;
        int i;
        int i2;
        super.paintComponent(graphics);
        if (!(graphics instanceof Graphics2D)) {
            graphics.drawString("Graphics is not Graphics2D, unable to render", 0, 0);
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int length = this.values.size();
        int width = this.getWidth();
        int height = this.getHeight();
        int maxScore = this.getMaxScore();
        int minScore = this.getMinScore();
        int scoreRange = maxScore - minScore;
        g.setColor(Color.WHITE);
        g.fillRect(35, 10, width - 20 - 25, height - 20 - 25);
        g.setColor(Color.BLACK);
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        for (i2 = 0; i2 < 11; ++i2) {
            int x12 = 35;
            int x2 = 39;
            int y = height - (i2 * (height - 20 - 25) / 10 + 10 + 25);
            if (length > 0) {
                g.setColor(gridColor);
                g.drawLine(40, y, width - 10, y);
                g.setColor(Color.BLACK);
                int tickValue = minScore + scoreRange * i2 / 10;
                String yLabel = "" + tickValue;
                int labelWidth = fontMetrics.stringWidth(yLabel);
                g.drawString(yLabel, 35 - labelWidth - 5, y + fontHeight / 2 - 3);
            }
            g.drawLine(35, y, 39, y);
        }
        if (length > 1) {
            for (i2 = 0; i2 < length; ++i2) {
                int x = i2 * (width - 20 - 25) / (length - 1) + 10 + 25;
                int y12 = height - 10 - 25;
                int y2 = y12 - 4;
                if (i2 % ((int)((double)length / 20.0) + 1) == 0) {
                    g.setColor(gridColor);
                    g.drawLine(x, height - 10 - 25 - 1 - 4, x, 10);
                    g.setColor(Color.BLACK);
                }
                g.drawLine(x, y12, x, y2);
            }
        }
        g.drawLine(35, height - 10 - 25, 35, 10);
        g.drawLine(35, height - 10 - 25, width - 10, height - 10 - 25);
        g.setColor(Color.BLACK);
        int labelWidth = fontMetrics.stringWidth(this.xLabel);
        int labelX = (35 + (width - 10)) / 2;
        int labelY = height - 10 - 25;
        g.drawString(this.xLabel, labelX - labelWidth / 2, labelY + fontHeight + 3);
        Stroke oldStroke = g.getStroke();
        g.setColor(lineColor);
        g.setStroke(graphStroke);
        double xScale = ((double)width - 20.0 - 25.0) / (double)(length - 1);
        double yScale = ((double)height - 20.0 - 25.0) / (double)scoreRange;
        ArrayList<Point> graphPoints = new ArrayList<Point>(length);
        for (i = 0; i < length; ++i) {
            x1 = (int)((double)i * xScale + 10.0 + 25.0);
            y1 = (int)((double)(maxScore - this.values.get(i)) * yScale + 10.0);
            graphPoints.add(new Point(x1, y1));
        }
        for (i = 0; i < graphPoints.size() - 1; ++i) {
            x1 = ((Point)graphPoints.get((int)i)).x;
            y1 = ((Point)graphPoints.get((int)i)).y;
            int x2 = ((Point)graphPoints.get((int)(i + 1))).x;
            int y2 = ((Point)graphPoints.get((int)(i + 1))).y;
            g.drawLine(x1, y1, x2, y2);
        }
        boolean bl = drawDots = width > length * 4;
        if (drawDots) {
            g.setStroke(oldStroke);
            g.setColor(pointColor);
            for (Point graphPoint : graphPoints) {
                int x = graphPoint.x - 2;
                int y = graphPoint.y - 2;
                g.fillOval(x, y, 4, 4);
            }
        }
    }

    private int getMinScore() {
        return 0;
    }

    private int getMaxScore() {
        return 100;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }
}

