/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.geysermc.geyser.network.netty.GeyserServer;

@ChannelHandler.Sharable
public class RakConnectionRequestHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "rak-connection-request-handler";
    private final GeyserServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) {
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        DatagramPacket packet = (DatagramPacket)msg;
        ByteBuf buf = (ByteBuf)packet.content();
        if (!buf.isReadable()) {
            return;
        }
        boolean readableMagic = true;
        int startIndex = buf.readerIndex();
        try {
            short packetId = buf.readUnsignedByte();
            if (packetId == 5) {
                ByteBuf magicBuf = ctx.channel().config().getOption(RakChannelOption.RAK_UNCONNECTED_MAGIC);
                if (!buf.isReadable(magicBuf.readableBytes()) || !ByteBufUtil.equals(buf.readSlice(magicBuf.readableBytes()), magicBuf)) {
                    readableMagic = false;
                }
            } else {
                readableMagic = false;
            }
        }
        finally {
            buf.readerIndex(startIndex);
        }
        if (!readableMagic) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf magicBuf = ctx.channel().config().getOption(RakChannelOption.RAK_UNCONNECTED_MAGIC);
        long guid = ctx.channel().config().getOption(RakChannelOption.RAK_GUID);
        if (!this.server.onConnectionRequest((InetSocketAddress)packet.sender())) {
            this.sendConnectionBanned(ctx, (InetSocketAddress)packet.sender(), magicBuf, guid);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void sendConnectionBanned(ChannelHandlerContext ctx, InetSocketAddress recipient, ByteBuf magicBuf, long guid) {
        ByteBuf buffer = ctx.alloc().ioBuffer(25, 25);
        buffer.writeByte(23);
        buffer.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        buffer.writeLong(guid);
        ctx.writeAndFlush(new DatagramPacket(buffer, recipient));
    }

    public RakConnectionRequestHandler(GeyserServer server) {
        this.server = server;
    }
}

