/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.component.GeometryComponent;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.PlacementConditions;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;

public final class GeyserCustomBlockComponents
implements CustomBlockComponents {
    private final BoxComponent selectionBox;
    private final BoxComponent collisionBox;
    private final String displayName;
    private final GeometryComponent geometry;
    private final Map<String, MaterialInstance> materialInstances;
    private final List<PlacementConditions> placementFilter;
    private final Float destructibleByMining;
    private final Float friction;
    private final Integer lightEmission;
    private final Integer lightDampening;
    private final TransformationComponent transformation;
    private final boolean placeAir;
    private final Set<String> tags;

    private GeyserCustomBlockComponents(Builder builder) {
        this.selectionBox = builder.selectionBox;
        this.collisionBox = builder.collisionBox;
        this.displayName = builder.displayName;
        GeometryComponent geo = builder.geometry;
        if (builder.unitCube && geo == null) {
            geo = GeometryComponent.builder().identifier("minecraft:geometry.full_block").build();
        }
        this.geometry = geo;
        this.materialInstances = builder.materialInstances.isEmpty() ? Object2ObjectMaps.emptyMap() : Object2ObjectMaps.unmodifiable(new Object2ObjectArrayMap<String, MaterialInstance>(builder.materialInstances));
        this.placementFilter = builder.placementFilter;
        this.destructibleByMining = builder.destructibleByMining;
        this.friction = builder.friction;
        this.lightEmission = builder.lightEmission;
        this.lightDampening = builder.lightDampening;
        this.transformation = builder.transformation;
        this.placeAir = builder.placeAir;
        this.tags = builder.tags.isEmpty() ? Set.of() : Set.copyOf(builder.tags);
    }

    @Override
    public BoxComponent selectionBox() {
        return this.selectionBox;
    }

    @Override
    public BoxComponent collisionBox() {
        return this.collisionBox;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public GeometryComponent geometry() {
        return this.geometry;
    }

    @Override
    public @NonNull Map<String, MaterialInstance> materialInstances() {
        return this.materialInstances;
    }

    @Override
    public List<PlacementConditions> placementFilter() {
        return this.placementFilter;
    }

    @Override
    public Float destructibleByMining() {
        return this.destructibleByMining;
    }

    @Override
    public Float friction() {
        return this.friction;
    }

    @Override
    public Integer lightEmission() {
        return this.lightEmission;
    }

    @Override
    public Integer lightDampening() {
        return this.lightDampening;
    }

    @Override
    public TransformationComponent transformation() {
        return this.transformation;
    }

    @Override
    public boolean unitCube() {
        return this.geometry.identifier().equals("minecraft:geometry.full_block");
    }

    @Override
    public boolean placeAir() {
        return this.placeAir;
    }

    @Override
    public @NonNull Set<String> tags() {
        return this.tags;
    }

    public BoxComponent getSelectionBox() {
        return this.selectionBox;
    }

    public BoxComponent getCollisionBox() {
        return this.collisionBox;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GeometryComponent getGeometry() {
        return this.geometry;
    }

    public Map<String, MaterialInstance> getMaterialInstances() {
        return this.materialInstances;
    }

    public List<PlacementConditions> getPlacementFilter() {
        return this.placementFilter;
    }

    public Float getDestructibleByMining() {
        return this.destructibleByMining;
    }

    public Float getFriction() {
        return this.friction;
    }

    public Integer getLightEmission() {
        return this.lightEmission;
    }

    public Integer getLightDampening() {
        return this.lightDampening;
    }

    public TransformationComponent getTransformation() {
        return this.transformation;
    }

    public boolean isPlaceAir() {
        return this.placeAir;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomBlockComponents)) {
            return false;
        }
        GeyserCustomBlockComponents other = (GeyserCustomBlockComponents)o;
        if (this.isPlaceAir() != other.isPlaceAir()) {
            return false;
        }
        Float this$destructibleByMining = this.getDestructibleByMining();
        Float other$destructibleByMining = other.getDestructibleByMining();
        if (this$destructibleByMining == null ? other$destructibleByMining != null : !((Object)this$destructibleByMining).equals(other$destructibleByMining)) {
            return false;
        }
        Float this$friction = this.getFriction();
        Float other$friction = other.getFriction();
        if (this$friction == null ? other$friction != null : !((Object)this$friction).equals(other$friction)) {
            return false;
        }
        Integer this$lightEmission = this.getLightEmission();
        Integer other$lightEmission = other.getLightEmission();
        if (this$lightEmission == null ? other$lightEmission != null : !((Object)this$lightEmission).equals(other$lightEmission)) {
            return false;
        }
        Integer this$lightDampening = this.getLightDampening();
        Integer other$lightDampening = other.getLightDampening();
        if (this$lightDampening == null ? other$lightDampening != null : !((Object)this$lightDampening).equals(other$lightDampening)) {
            return false;
        }
        BoxComponent this$selectionBox = this.getSelectionBox();
        BoxComponent other$selectionBox = other.getSelectionBox();
        if (this$selectionBox == null ? other$selectionBox != null : !((Object)this$selectionBox).equals(other$selectionBox)) {
            return false;
        }
        BoxComponent this$collisionBox = this.getCollisionBox();
        BoxComponent other$collisionBox = other.getCollisionBox();
        if (this$collisionBox == null ? other$collisionBox != null : !((Object)this$collisionBox).equals(other$collisionBox)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        GeometryComponent this$geometry = this.getGeometry();
        GeometryComponent other$geometry = other.getGeometry();
        if (this$geometry == null ? other$geometry != null : !this$geometry.equals(other$geometry)) {
            return false;
        }
        Map<String, MaterialInstance> this$materialInstances = this.getMaterialInstances();
        Map<String, MaterialInstance> other$materialInstances = other.getMaterialInstances();
        if (this$materialInstances == null ? other$materialInstances != null : !((Object)this$materialInstances).equals(other$materialInstances)) {
            return false;
        }
        List<PlacementConditions> this$placementFilter = this.getPlacementFilter();
        List<PlacementConditions> other$placementFilter = other.getPlacementFilter();
        if (this$placementFilter == null ? other$placementFilter != null : !((Object)this$placementFilter).equals(other$placementFilter)) {
            return false;
        }
        TransformationComponent this$transformation = this.getTransformation();
        TransformationComponent other$transformation = other.getTransformation();
        if (this$transformation == null ? other$transformation != null : !((Object)this$transformation).equals(other$transformation)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPlaceAir() ? 79 : 97);
        Float $destructibleByMining = this.getDestructibleByMining();
        result = result * 59 + ($destructibleByMining == null ? 43 : ((Object)$destructibleByMining).hashCode());
        Float $friction = this.getFriction();
        result = result * 59 + ($friction == null ? 43 : ((Object)$friction).hashCode());
        Integer $lightEmission = this.getLightEmission();
        result = result * 59 + ($lightEmission == null ? 43 : ((Object)$lightEmission).hashCode());
        Integer $lightDampening = this.getLightDampening();
        result = result * 59 + ($lightDampening == null ? 43 : ((Object)$lightDampening).hashCode());
        BoxComponent $selectionBox = this.getSelectionBox();
        result = result * 59 + ($selectionBox == null ? 43 : ((Object)$selectionBox).hashCode());
        BoxComponent $collisionBox = this.getCollisionBox();
        result = result * 59 + ($collisionBox == null ? 43 : ((Object)$collisionBox).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        GeometryComponent $geometry = this.getGeometry();
        result = result * 59 + ($geometry == null ? 43 : $geometry.hashCode());
        Map<String, MaterialInstance> $materialInstances = this.getMaterialInstances();
        result = result * 59 + ($materialInstances == null ? 43 : ((Object)$materialInstances).hashCode());
        List<PlacementConditions> $placementFilter = this.getPlacementFilter();
        result = result * 59 + ($placementFilter == null ? 43 : ((Object)$placementFilter).hashCode());
        TransformationComponent $transformation = this.getTransformation();
        result = result * 59 + ($transformation == null ? 43 : ((Object)$transformation).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserCustomBlockComponents(selectionBox=" + String.valueOf(this.getSelectionBox()) + ", collisionBox=" + String.valueOf(this.getCollisionBox()) + ", displayName=" + this.getDisplayName() + ", geometry=" + String.valueOf(this.getGeometry()) + ", materialInstances=" + String.valueOf(this.getMaterialInstances()) + ", placementFilter=" + String.valueOf(this.getPlacementFilter()) + ", destructibleByMining=" + this.getDestructibleByMining() + ", friction=" + this.getFriction() + ", lightEmission=" + this.getLightEmission() + ", lightDampening=" + this.getLightDampening() + ", transformation=" + String.valueOf(this.getTransformation()) + ", placeAir=" + this.isPlaceAir() + ", tags=" + String.valueOf(this.getTags()) + ")";
    }

    public static class Builder
    implements CustomBlockComponents.Builder {
        protected BoxComponent selectionBox;
        protected BoxComponent collisionBox;
        protected String displayName;
        protected GeometryComponent geometry;
        protected final Object2ObjectMap<String, MaterialInstance> materialInstances = new Object2ObjectOpenHashMap<String, MaterialInstance>();
        protected List<PlacementConditions> placementFilter;
        protected Float destructibleByMining;
        protected Float friction;
        protected Integer lightEmission;
        protected Integer lightDampening;
        protected TransformationComponent transformation;
        protected boolean unitCube = false;
        protected boolean placeAir = false;
        protected Set<String> tags = new HashSet<String>();

        private void validateBox(BoxComponent box) {
            if (box == null) {
                return;
            }
            if (box.sizeX() < 0.0f || box.sizeY() < 0.0f || box.sizeZ() < 0.0f) {
                throw new IllegalArgumentException("Box size must be non-negative.");
            }
            float minX = box.originX() + 8.0f;
            float minY = box.originY();
            float minZ = box.originZ() + 8.0f;
            float maxX = minX + box.sizeX();
            float maxY = minY + box.sizeY();
            float maxZ = minZ + box.sizeZ();
            if (minX < 0.0f || minY < 0.0f || minZ < 0.0f || maxX > 16.0f || maxY > 16.0f || maxZ > 16.0f) {
                throw new IllegalArgumentException("Box bounds must be within (0, 0, 0) and (16, 16, 16). Recieved: (" + minX + ", " + minY + ", " + minZ + ") to (" + maxX + ", " + maxY + ", " + maxZ + ")");
            }
        }

        @Override
        public Builder selectionBox(BoxComponent selectionBox) {
            this.validateBox(selectionBox);
            this.selectionBox = selectionBox;
            return this;
        }

        @Override
        public Builder collisionBox(BoxComponent collisionBox) {
            this.validateBox(collisionBox);
            this.collisionBox = collisionBox;
            return this;
        }

        @Override
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder geometry(GeometryComponent geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public Builder materialInstance(@NonNull String name, @NonNull MaterialInstance materialInstance) {
            this.materialInstances.put(name, materialInstance);
            return this;
        }

        @Override
        public Builder placementFilter(List<PlacementConditions> placementFilter) {
            this.placementFilter = placementFilter;
            return this;
        }

        @Override
        public Builder destructibleByMining(Float destructibleByMining) {
            if (destructibleByMining != null && destructibleByMining.floatValue() < 0.0f) {
                throw new IllegalArgumentException("Destructible by mining must be non-negative");
            }
            this.destructibleByMining = destructibleByMining;
            return this;
        }

        @Override
        public Builder friction(Float friction) {
            if (friction != null && (friction.floatValue() < 0.0f || friction.floatValue() > 1.0f)) {
                throw new IllegalArgumentException("Friction must be in the range 0-1");
            }
            this.friction = friction;
            return this;
        }

        @Override
        public Builder lightEmission(Integer lightEmission) {
            if (lightEmission != null && (lightEmission < 0 || lightEmission > 15)) {
                throw new IllegalArgumentException("Light emission must be in the range 0-15");
            }
            this.lightEmission = lightEmission;
            return this;
        }

        @Override
        public Builder lightDampening(Integer lightDampening) {
            if (lightDampening != null && (lightDampening < 0 || lightDampening > 15)) {
                throw new IllegalArgumentException("Light dampening must be in the range 0-15");
            }
            this.lightDampening = lightDampening;
            return this;
        }

        @Override
        public Builder transformation(TransformationComponent transformation) {
            if (transformation.rx() % 90 != 0 || transformation.ry() % 90 != 0 || transformation.rz() % 90 != 0) {
                throw new IllegalArgumentException("Rotation of transformation must be a multiple of 90 degrees.");
            }
            this.transformation = transformation;
            return this;
        }

        @Override
        public Builder unitCube(boolean unitCube) {
            this.unitCube = unitCube;
            return this;
        }

        @Override
        public Builder placeAir(boolean placeAir) {
            this.placeAir = placeAir;
            return this;
        }

        @Override
        public Builder tags(@Nullable Set<String> tags) {
            this.tags = Objects.requireNonNullElseGet(tags, Set::of);
            return this;
        }

        @Override
        public CustomBlockComponents build() {
            return new GeyserCustomBlockComponents(this);
        }
    }
}

