/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import com.google.common.hash.HashCode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHashEncoder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;

public class MapHasher<Type> {
    private static final boolean DEBUG = false;
    private final MinecraftHashEncoder encoder;
    private final Type object;
    private final Map<HashCode, HashCode> map;
    private final Map<String, Object> unhashed;

    MapHasher(Type object, MinecraftHashEncoder encoder) {
        this(object, encoder, new HashMap<HashCode, HashCode>(), null);
    }

    private MapHasher(Type object, MinecraftHashEncoder encoder, Map<HashCode, HashCode> map, Map<String, Object> unhashed) {
        this.encoder = encoder;
        this.object = object;
        this.map = map;
        this.unhashed = unhashed;
    }

    private MapHasher<Type> accept(String key, HashCode hash) {
        this.map.put(this.encoder.string(key), hash);
        return this;
    }

    private MapHasher<Type> accept(String key, Object value, HashCode valueHash) {
        if (this.unhashed != null) {
            this.unhashed.put(key, value);
        }
        this.map.put(this.encoder.string(key), valueHash);
        return this;
    }

    public <Value> MapHasher<Type> acceptConstant(String key, MinecraftHasher<Value> hasher, Value value) {
        if (this.unhashed != null) {
            this.unhashed.put(key, value);
        }
        return this.accept(key, hasher.hash(value, this.encoder));
    }

    public MapHasher<Type> inlineNbt(Function<Type, NbtMap> extractor) {
        NbtMap nbtMap = extractor.apply(this.object);
        for (String key : nbtMap.keySet()) {
            Object value = nbtMap.get(key);
            if (value instanceof NbtList) {
                NbtList list = (NbtList)value;
                this.accept(key, value, this.encoder.nbtList(list));
                continue;
            }
            nbtMap.listenForNumber(key, n -> this.accept(key, value, this.encoder.number(n)));
            nbtMap.listenForString(key, s -> this.accept(key, value, this.encoder.string((String)s)));
            nbtMap.listenForCompound(key, compound -> this.accept(key, value, this.encoder.nbtMap((NbtMap)compound)));
            nbtMap.listenForByteArray(key, bytes -> this.accept(key, value, this.encoder.byteArray((byte[])bytes)));
            nbtMap.listenForIntArray(key, ints -> this.accept(key, value, this.encoder.intArray((int[])ints)));
            nbtMap.listenForLongArray(key, longs -> this.accept(key, value, this.encoder.longArray((long[])longs)));
        }
        return this;
    }

    public <Value> MapHasher<Type> accept(String key, MinecraftHasher<Value> hasher, Function<Type, Value> extractor) {
        return this.acceptConstant(key, hasher, extractor.apply(this.object));
    }

    public MapHasher<Type> accept(MapBuilder<Type> builder) {
        builder.apply(this);
        return this;
    }

    public <Value> MapHasher<Type> accept(MapBuilder<Value> builder, Function<Type, Value> extractor) {
        builder.apply(new MapHasher<Value>(extractor.apply(this.object), this.encoder, this.map, this.unhashed));
        return this;
    }

    public <Value> MapHasher<Type> accept(Function<Type, Value> extractor, Function<Value, MapBuilder<Type>> builderDispatcher) {
        builderDispatcher.apply(extractor.apply(this.object)).apply(this);
        return this;
    }

    public <Value> MapHasher<Type> optionalNullable(String key, MinecraftHasher<Value> hasher, Function<Type, Value> extractor) {
        return this.optionalPredicate(key, hasher, extractor, Objects::nonNull);
    }

    public <Value> MapHasher<Type> optional(String key, MinecraftHasher<Value> hasher, Function<Type, Optional<Value>> extractor) {
        Optional<Value> value = extractor.apply(this.object);
        value.ifPresent(v -> this.acceptConstant(key, hasher, v));
        return this;
    }

    public <Value> MapHasher<Type> optional(String key, MinecraftHasher<Value> hasher, Function<Type, Value> extractor, Value defaultValue) {
        return this.optionalPredicate(key, hasher, extractor, value -> !value.equals(defaultValue));
    }

    public <Value> MapHasher<Type> optionalPredicate(String key, MinecraftHasher<Value> hasher, Function<Type, Value> extractor, Predicate<Value> predicate) {
        Value value = extractor.apply(this.object);
        if (predicate.test(value)) {
            this.acceptConstant(key, hasher, value);
        }
        return this;
    }

    public <Value> MapHasher<Type> acceptList(String key, MinecraftHasher<Value> valueHasher, Function<Type, List<Value>> extractor) {
        return this.acceptConstant(key, valueHasher.list(), extractor.apply(this.object));
    }

    public <Value> MapHasher<Type> optionalList(String key, MinecraftHasher<Value> valueHasher, Function<Type, List<Value>> extractor) {
        List<Value> list = extractor.apply(this.object);
        if (!list.isEmpty()) {
            this.acceptConstant(key, valueHasher.list(), list);
        }
        return this;
    }

    public HashCode build() {
        return this.encoder.map(this.map);
    }
}

