/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import java.util.ArrayList;
import java.util.function.IntFunction;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class ChestInventoryUpdater
extends InventoryUpdater {
    private static final IntFunction<ItemData> UNUSUABLE_SPACE_BLOCK = InventoryUtils.createUnusableSpaceBlock(GeyserLocale.getLocaleStringLog("geyser.inventory.unusable_item.slot"));
    private final int paddedSize;

    @Override
    public void updateInventory(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory) {
        super.updateInventory(translator, session, inventory);
        ArrayList<ItemData> bedrockItems = new ArrayList<ItemData>(this.paddedSize);
        for (int i = 0; i < this.paddedSize; ++i) {
            if (i < translator.size) {
                bedrockItems.add(inventory.getItem(i).getItemData(session));
                continue;
            }
            bedrockItems.add(UNUSUABLE_SPACE_BLOCK.apply(session.getUpstream().getProtocolVersion()));
        }
        InventoryContentPacket contentPacket = new InventoryContentPacket();
        contentPacket.setContainerId(inventory.getBedrockId());
        contentPacket.setContents(bedrockItems);
        session.sendUpstreamPacket(contentPacket);
    }

    @Override
    public boolean updateSlot(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory, int javaSlot) {
        if (super.updateSlot(translator, session, inventory, javaSlot)) {
            return true;
        }
        InventorySlotPacket slotPacket = new InventorySlotPacket();
        slotPacket.setContainerId(inventory.getBedrockId());
        slotPacket.setSlot(translator.javaSlotToBedrock(javaSlot));
        slotPacket.setItem(inventory.getItem(javaSlot).getItemData(session));
        session.sendUpstreamPacket(slotPacket);
        return true;
    }

    public ChestInventoryUpdater(int paddedSize) {
        this.paddedSize = paddedSize;
    }
}

