/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.cloudburstmc.math.TrigMath;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;

public class BoostableVehicleComponent<T extends LivingEntity>
extends VehicleComponent<T> {
    private int boostLength;
    private int boostTicks = 1;

    public BoostableVehicleComponent(T vehicle, float stepHeight) {
        super(vehicle, stepHeight);
    }

    public void startBoost(int boostLength) {
        this.boostLength = boostLength;
        this.boostTicks = 1;
    }

    public float getBoostMultiplier() {
        if (this.isBoosting()) {
            return 1.0f + 1.15f * TrigMath.sin((double)((float)this.boostTicks / (float)this.boostLength) * Math.PI);
        }
        return 1.0f;
    }

    public boolean isBoosting() {
        return this.boostTicks <= this.boostLength;
    }

    public void tickBoost() {
        if (this.isBoosting()) {
            ++this.boostTicks;
        }
    }
}

