/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.ThrowableEntity;
import org.geysermc.geyser.session.GeyserSession;

public class FireballEntity
extends ThrowableEntity {
    private final Vector3f acceleration;
    protected int futureTicks = 3;

    public FireballEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, Vector3f.ZERO, yaw, pitch, headYaw);
        float magnitude = motion.length();
        this.acceleration = magnitude != 0.0f ? motion.div(magnitude).mul(0.1f) : Vector3f.ZERO;
    }

    private Vector3f tickMovement(Vector3f position) {
        position = position.add(this.motion);
        float drag = this.getDrag();
        this.motion = this.motion.add(this.acceleration).mul(drag);
        return position;
    }

    @Override
    protected void moveAbsoluteImmediate(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        Vector3f lastMotion = this.motion;
        Vector3f newPosition = position;
        for (int i = 0; i < this.futureTicks; ++i) {
            newPosition = this.tickMovement(newPosition);
        }
        super.moveAbsoluteImmediate(newPosition, yaw, pitch, headYaw, isOnGround, teleported);
        this.position = position;
        this.motion = lastMotion;
    }

    @Override
    public void tick() {
        if (this.removedInVoid()) {
            return;
        }
        this.moveAbsoluteImmediate(this.tickMovement(this.position), this.getYaw(), this.getPitch(), this.getHeadYaw(), false, false);
    }
}

