/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.geysermc.floodgate.news.data.ItemData;

public final class ConfigSpecificData
implements ItemData {
    private final Map<String, Pattern> affectedKeys = new HashMap<String, Pattern>();

    private ConfigSpecificData() {
    }

    public static ConfigSpecificData read(JsonObject data) {
        ConfigSpecificData configSpecificData = new ConfigSpecificData();
        JsonArray entries = data.getAsJsonArray("entries");
        for (JsonElement element : entries) {
            JsonObject entry = element.getAsJsonObject();
            String key = entry.get("key").getAsString();
            String pattern = entry.get("pattern").getAsString();
            configSpecificData.affectedKeys.put(key, Pattern.compile(pattern));
        }
        return configSpecificData;
    }

    public boolean isAffected(Map<String, String> config) {
        for (Map.Entry<String, Pattern> entry : this.affectedKeys.entrySet()) {
            if (!config.containsKey(entry.getKey())) continue;
            String value = config.get(entry.getKey());
            if (!entry.getValue().matcher(value).matches()) continue;
            return true;
        }
        return false;
    }
}

