/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.bus.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.FireResult;
import org.geysermc.event.bus.BaseBus;
import org.geysermc.event.bus.impl.util.Utils;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.event.subscribe.Subscriber;
import org.geysermc.event.util.TriConsumer;
import org.lanternpowered.lmbda.LambdaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseBusImpl<E, S extends Subscriber<? extends E>>
implements BaseBus<E, S> {
    private static final MethodHandles.Lookup CALLER = MethodHandles.lookup();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SetMultimap<Class<?>, Subscriber<?>> subscribers = Multimaps.synchronizedSetMultimap(HashMultimap.create());
    private Class<? super E> eventType;
    private final SetMultimap<Subscriber<?>, Class<?>> subscriberCacheEntries = Multimaps.synchronizedSetMultimap(HashMultimap.create());
    private final LoadingCache<Class<?>, List<Subscriber<?>>> sortedSubscribersCache = CacheBuilder.newBuilder().removalListener(listener -> {
        Class eventClass = (Class)listener.getKey();
        List subscribers = (List)listener.getValue();
        SetMultimap<Subscriber<?>, Class<?>> setMultimap = this.subscriberCacheEntries;
        synchronized (setMultimap) {
            for (Subscriber subscriber : subscribers) {
                this.subscriberCacheEntries.remove(subscriber, eventClass);
            }
        }
    }).build(CacheLoader.from(eventClass -> {
        Set<Class<?>> ancestors = Utils.ancestorsThatUse(eventClass, this.eventType);
        List sortedSubscribers = new ArrayList<Subscriber>();
        SetMultimap<Object, Object> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            for (Class<?> ancestor : ancestors) {
                sortedSubscribers.addAll(this.subscribers.get((Object)ancestor));
            }
        }
        sortedSubscribers.sort(Comparator.comparingInt(s -> s.order().ordinal()));
        sortedSubscribers = Collections.unmodifiableList(sortedSubscribers);
        setMultimap = this.subscriberCacheEntries;
        synchronized (setMultimap) {
            for (Subscriber subscriber : sortedSubscribers) {
                this.subscriberCacheEntries.put(subscriber, (Class<?>)eventClass);
            }
        }
        return sortedSubscribers;
    }));

    public BaseBusImpl() {
        this.eventType = new TypeToken<E>(this.getClass()){}.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends E> void register(Class<T> eventClass, S subscriber) {
        Preconditions.checkArgument(this.eventType.isAssignableFrom(eventClass));
        Preconditions.checkArgument(subscriber.eventClass().isAssignableFrom(eventClass));
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            this.subscribers.put(eventClass, (Subscriber<?>)subscriber);
            this.sortedSubscribersCache.invalidate(eventClass);
        }
    }

    protected <T extends E> void findSubscriptions(@NonNull Object listener, TriConsumer<Class<T>, Subscribe, BiConsumer<Object, T>> consumer) {
        for (Class<?> currentClass = listener.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                Class<?> firstParameterType;
                Subscribe subscribe = method.getAnnotation(Subscribe.class);
                if (subscribe == null || method.getParameterCount() > 1 || !this.eventType.isAssignableFrom(firstParameterType = method.getParameters()[0].getType())) continue;
                method.setAccessible(true);
                try {
                    consumer.accept(firstParameterType, subscribe, LambdaFactory.createBiConsumer(CALLER.unreflect(method)));
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(@NonNull S subscription) {
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            Class eventClass = subscription.eventClass();
            if (!this.subscribers.remove(eventClass, subscription)) {
                this.sortedSubscribersCache.invalidate(eventClass);
            }
        }
    }

    protected void unsubscribeMany(Iterable<S> subscriptions) {
        for (Subscriber subscription : subscriptions) {
            this.unsubscribe(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        SetMultimap<Class<?>, Subscriber<?>> setMultimap = this.subscribers;
        synchronized (setMultimap) {
            this.subscribers.clear();
        }
        this.sortedSubscribersCache.invalidateAll();
    }

    @Override
    public FireResult fire(@NonNull E event) {
        FireResult result = this.fireSilently(event);
        if (!result.success()) {
            result.exceptions().forEach((subscriber, throwable) -> this.logger.error("An exception occurred while executing event {} for subscriber {}", event.getClass().getSimpleName(), subscriber.getClass().getName(), throwable));
        }
        return result;
    }

    @Override
    public FireResult fireSilently(@NonNull E event) {
        HashMap thrown = new HashMap();
        for (Subscriber subscriber : this.sortedSubscribers(event.getClass())) {
            if (!Utils.shouldCallSubscriber(subscriber, event)) continue;
            try {
                subscriber.invoke(event);
            }
            catch (Throwable throwable) {
                thrown.put(subscriber, throwable);
            }
        }
        return FireResult.resultFor(thrown);
    }

    protected List<S> sortedSubscribers(Class<?> eventClass) {
        return this.sortedSubscribersCache.getUnchecked(eventClass);
    }

    protected <T extends Subscriber<U>, U> Set<T> eventSubscribers(Class<U> eventType) {
        return BaseBusImpl.castGenericSet(this.subscribers.get((Object)eventType));
    }

    protected static <T extends U, U> Set<T> castGenericSet(Set<U> o) {
        return o;
    }
}

