/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.impl.DropdownComponentImpl;
import org.geysermc.cumulus.component.impl.InputComponentImpl;
import org.geysermc.cumulus.component.impl.LabelComponentImpl;
import org.geysermc.cumulus.component.impl.SliderComponentImpl;
import org.geysermc.cumulus.component.impl.StepSliderComponentImpl;
import org.geysermc.cumulus.component.impl.ToggleComponentImpl;
import org.geysermc.cumulus.component.util.ComponentType;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.cumulus.util.JsonUtils;

public final class Forms {
    public static <T extends Form> @NonNull T fromJson(String json, FormType type, BiConsumer<T, @Nullable String> responseHandler) {
        return FormDefinitions.instance().codecFor(type).fromJson(json, responseHandler);
    }

    @Deprecated
    public static @NonNull Class<? extends Form> getFormTypeImpl(FormType type) {
        return FormDefinitions.instance().formImplClass(type);
    }

    public static @NonNull Class<? extends Component> getComponentTypeImpl(@NonNull ComponentType type) {
        switch (type) {
            case DROPDOWN: {
                return DropdownComponentImpl.class;
            }
            case INPUT: {
                return InputComponentImpl.class;
            }
            case LABEL: {
                return LabelComponentImpl.class;
            }
            case SLIDER: {
                return SliderComponentImpl.class;
            }
            case STEP_SLIDER: {
                return StepSliderComponentImpl.class;
            }
            case TOGGLE: {
                return ToggleComponentImpl.class;
            }
        }
        throw new RuntimeException("Cannot find implementation for ComponentType " + (Object)((Object)type));
    }

    @Deprecated
    public static @NonNull JsonElement getOrThrow(@NonNull JsonObject object, @NonNull String memberName) {
        return JsonUtils.assumeMember(object, memberName);
    }
}

