/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock;

import io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.packet.DisconnectPacket;

public class BedrockServerSession
extends BedrockSession {
    private static final int TIMEOUT_SECONDS = SystemPropertyUtil.getInt("org.cloudburstmc.protocol.bedrock.disconnectTimeout", 10);

    public BedrockServerSession(BedrockPeer peer, int subClientId) {
        super(peer, subClientId);
    }

    @Override
    public void disconnect(@Nullable CharSequence reason, boolean hideReason) {
        CharSequence finalReason;
        this.checkForClosed();
        DisconnectPacket packet = new DisconnectPacket();
        if (reason == null || hideReason) {
            packet.setMessageSkipped(true);
            finalReason = "disconnect.disconnected";
        } else {
            finalReason = reason;
        }
        packet.setKickMessage(finalReason);
        this.sendPacketImmediately(packet);
        if (!this.isSubClient()) {
            this.getPeer().blackholeInboundPackets();
        }
        this.getPeer().channel.eventLoop().schedule(() -> {
            if (this.isConnected()) {
                this.close(finalReason);
            }
        }, (long)TIMEOUT_SECONDS, TimeUnit.SECONDS);
    }
}

