/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.util.JsonUtil;
import net.raphimc.minecraftauth.util.OAuthEnvironment;
import net.raphimc.minecraftauth.util.UuidUtil;
import net.raphimc.minecraftauth.util.logging.ILogger;

public abstract class AbstractStep<I extends StepResult<?>, O extends StepResult<?>> {
    public final String name;
    public final ApplicationDetails applicationDetails;
    protected final AbstractStep<?, I> prevStep;

    public AbstractStep(String name) {
        this.name = name;
        this.applicationDetails = null;
        this.prevStep = null;
    }

    public AbstractStep(String name, AbstractStep<?, I> prevStep) {
        this.name = name;
        this.applicationDetails = prevStep.applicationDetails;
        this.prevStep = prevStep;
    }

    public AbstractStep(String name, ApplicationDetails applicationDetails) {
        this.name = name;
        this.applicationDetails = applicationDetails;
        this.prevStep = null;
    }

    protected abstract O execute(ILogger var1, HttpClient var2, I var3) throws Exception;

    public final O refresh(HttpClient httpClient, O result) throws Exception {
        return this.refresh(MinecraftAuth.LOGGER, httpClient, result);
    }

    public O refresh(ILogger logger, HttpClient httpClient, O result) throws Exception {
        if (!((StepResult)result).isExpiredOrOutdated()) {
            return result;
        }
        return this.execute(logger, httpClient, this.prevStep != null ? (I)this.prevStep.refresh(logger, httpClient, ((StepResult)result).prevResult()) : null);
    }

    public final O getFromInput(HttpClient httpClient, InitialInput input) throws Exception {
        return this.getFromInput(MinecraftAuth.LOGGER, httpClient, input);
    }

    public O getFromInput(ILogger logger, HttpClient httpClient, InitialInput input) throws Exception {
        return this.execute(logger, httpClient, this.prevStep != null ? this.prevStep.getFromInput(logger, httpClient, input) : input);
    }

    public abstract O fromJson(JsonObject var1);

    public abstract JsonObject toJson(O var1);

    public static final class ApplicationDetails {
        private final String clientId;
        private final String scope;
        private final String clientSecret;
        private final String redirectUri;
        private final OAuthEnvironment oAuthEnvironment;

        public static ApplicationDetails fromJson(JsonObject json) {
            return new ApplicationDetails(json.get("clientId").getAsString(), json.get("scope").getAsString(), JsonUtil.getStringOr(json, "clientSecret", null), JsonUtil.getStringOr(json, "redirectUri", null), OAuthEnvironment.valueOf(JsonUtil.getStringOr(json, "oAuthEnvironment", "LIVE")));
        }

        public static JsonObject toJson(ApplicationDetails applicationDetails) {
            JsonObject json = new JsonObject();
            json.addProperty("clientId", applicationDetails.clientId);
            json.addProperty("scope", applicationDetails.scope);
            json.addProperty("clientSecret", applicationDetails.clientSecret);
            json.addProperty("redirectUri", applicationDetails.redirectUri);
            json.addProperty("oAuthEnvironment", applicationDetails.oAuthEnvironment.name());
            return json;
        }

        public boolean isTitleClientId() {
            return !UuidUtil.isDashedUuid(this.clientId);
        }

        public Map<String, String> getOAuthParameters() {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("client_id", this.clientId);
            parameters.put("scope", this.scope);
            parameters.put("redirect_uri", this.redirectUri);
            parameters.put("response_type", "code");
            parameters.put("response_mode", "query");
            return parameters;
        }

        @Generated
        public ApplicationDetails(String clientId, String scope, String clientSecret, String redirectUri, OAuthEnvironment oAuthEnvironment) {
            this.clientId = clientId;
            this.scope = scope;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
            this.oAuthEnvironment = oAuthEnvironment;
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public String getClientSecret() {
            return this.clientSecret;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public OAuthEnvironment getOAuthEnvironment() {
            return this.oAuthEnvironment;
        }

        @Generated
        public String toString() {
            return "AbstractStep.ApplicationDetails(clientId=" + this.getClientId() + ", scope=" + this.getScope() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ", oAuthEnvironment=" + (Object)((Object)this.getOAuthEnvironment()) + ")";
        }

        @Generated
        public ApplicationDetails withClientId(String clientId) {
            return this.clientId == clientId ? this : new ApplicationDetails(clientId, this.scope, this.clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        @Generated
        public ApplicationDetails withScope(String scope) {
            return this.scope == scope ? this : new ApplicationDetails(this.clientId, scope, this.clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        @Generated
        public ApplicationDetails withClientSecret(String clientSecret) {
            return this.clientSecret == clientSecret ? this : new ApplicationDetails(this.clientId, this.scope, clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        @Generated
        public ApplicationDetails withRedirectUri(String redirectUri) {
            return this.redirectUri == redirectUri ? this : new ApplicationDetails(this.clientId, this.scope, this.clientSecret, redirectUri, this.oAuthEnvironment);
        }

        @Generated
        public ApplicationDetails withOAuthEnvironment(OAuthEnvironment oAuthEnvironment) {
            return this.oAuthEnvironment == oAuthEnvironment ? this : new ApplicationDetails(this.clientId, this.scope, this.clientSecret, this.redirectUri, oAuthEnvironment);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationDetails)) {
                return false;
            }
            ApplicationDetails other = (ApplicationDetails)o;
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            OAuthEnvironment this$oAuthEnvironment = this.getOAuthEnvironment();
            OAuthEnvironment other$oAuthEnvironment = other.getOAuthEnvironment();
            return !(this$oAuthEnvironment == null ? other$oAuthEnvironment != null : !((Object)((Object)this$oAuthEnvironment)).equals((Object)other$oAuthEnvironment));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            OAuthEnvironment $oAuthEnvironment = this.getOAuthEnvironment();
            result = result * 59 + ($oAuthEnvironment == null ? 43 : ((Object)((Object)$oAuthEnvironment)).hashCode());
            return result;
        }
    }

    public static abstract class InitialInput
    extends StepResult<StepResult<?>> {
        @Override
        protected final StepResult<?> prevResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExpired() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class FirstStepResult
    extends StepResult<StepResult<?>> {
        @Override
        protected final StepResult<?> prevResult() {
            return null;
        }
    }

    public static abstract class StepResult<P extends StepResult<?>> {
        protected abstract P prevResult();

        public abstract boolean isExpired();

        public boolean isExpiredOrOutdated() {
            return this.isExpired();
        }
    }
}

