/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.service.realms;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.DeleteRequest;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.RealmsResponseHandler;
import net.raphimc.minecraftauth.service.realms.AbstractRealmsService;
import net.raphimc.minecraftauth.service.realms.model.RealmsWorld;
import net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;

public class BedrockRealmsService
extends AbstractRealmsService {
    public static final String JOIN_WORLD_URL = "https://pocket.realms.minecraft.net/worlds/$ID/join";
    public static final String ACCEPT_INVITE_URL = "https://pocket.realms.minecraft.net/invites/v1/link/accept/$CODE";
    public static final String DELETE_INVITE_URL = "https://pocket.realms.minecraft.net/invites/$ID";
    private final StepXblXstsToken.XblXsts<?> realmsXsts;
    private final String clientVersion;

    public BedrockRealmsService(HttpClient httpClient, String clientVersion, StepXblXstsToken.XblXsts<?> realmsXsts) {
        super("pocket.realms.minecraft.net", httpClient, null);
        this.realmsXsts = realmsXsts;
        this.clientVersion = clientVersion;
    }

    @Override
    public CompletableFuture<String> joinWorld(final RealmsWorld realmsWorld) {
        return CompletableFuture.supplyAsync(new Supplier<String>(){

            @Override
            public String get() {
                GetRequest getRequest = new GetRequest(BedrockRealmsService.JOIN_WORLD_URL.replace("$ID", String.valueOf(realmsWorld.getId())));
                BedrockRealmsService.this.addRequestHeaders(getRequest);
                JsonObject obj = BedrockRealmsService.this.httpClient.execute(getRequest, new RealmsResponseHandler());
                return obj.get("address").getAsString();
            }
        });
    }

    public CompletableFuture<RealmsWorld> acceptInvite(final String realmCode) {
        return CompletableFuture.supplyAsync(new Supplier<RealmsWorld>(){

            @Override
            public RealmsWorld get() {
                PostRequest postRequest = new PostRequest(BedrockRealmsService.ACCEPT_INVITE_URL.replace("$CODE", realmCode));
                BedrockRealmsService.this.addRequestHeaders(postRequest);
                JsonObject obj = BedrockRealmsService.this.httpClient.execute(postRequest, new RealmsResponseHandler());
                return RealmsWorld.fromJson(obj);
            }
        });
    }

    public CompletableFuture<Void> leaveInvitedRealm(final RealmsWorld realmsWorld) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DeleteRequest deleteRequest = new DeleteRequest(BedrockRealmsService.DELETE_INVITE_URL.replace("$ID", String.valueOf(realmsWorld.getId())));
                BedrockRealmsService.this.addRequestHeaders(deleteRequest);
                JsonObject obj = BedrockRealmsService.this.httpClient.execute(deleteRequest, new RealmsResponseHandler());
                if (obj != null) {
                    throw new IllegalStateException("Failed to delete invite: " + obj);
                }
            }
        });
    }

    @Override
    protected void addRequestHeaders(HttpRequest httpRequest) {
        httpRequest.setHeader("Authorization", "XBL3.0 x=" + this.realmsXsts.getServiceToken());
        httpRequest.setHeader("Client-Version", this.clientVersion);
    }
}

