/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import lombok.Generated;

public final class HttpRequestUtils {
    @SafeVarargs
    public static Map<String, List<String>> mergeHeaders(Map<String, List<String>> ... maps) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (Map<String, List<String>> map : maps) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                headers.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
            }
        }
        return headers;
    }

    public static Map<String, List<String>> getCookieHeaders(@Nullable CookieManager cookieManager, URL url) throws IOException {
        try {
            if (cookieManager == null) {
                return Collections.emptyMap();
            }
            return cookieManager.get(url.toURI(), Collections.emptyMap());
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse URL as URI", e);
        }
    }

    public static void updateCookies(@Nullable CookieManager cookieManager, URL url, Map<String, List<String>> headers) throws IOException {
        if (cookieManager == null) {
            return;
        }
        try {
            cookieManager.put(url.toURI(), headers);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse URL as URI", e);
        }
    }

    public static void setHeaders(HttpURLConnection connection, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), String.join((CharSequence)"; ", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }

    public static byte[] readBody(HttpURLConnection connection) throws IOException {
        InputStream is = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        if (is == null) {
            return new byte[0];
        }
        return HttpRequestUtils.readFromStream(is);
    }

    public static byte[] readFromStream(@WillNotClose InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    public static Instant parseHttpDate(String httpDate) throws DateTimeParseException {
        return Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(httpDate));
    }

    @Nullable
    public static Long parseSecondsOrHttpDate(String value) {
        try {
            Instant date = HttpRequestUtils.parseHttpDate(value);
            return date.toEpochMilli() - Instant.now().toEpochMilli();
        }
        catch (DateTimeParseException date) {
            try {
                int seconds = Integer.parseInt(value);
                return (long)seconds * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    @Generated
    private HttpRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

