/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.codec.PacketDefinition;
import org.geysermc.mcprotocollib.network.event.session.PacketErrorEvent;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.packet.PacketRegistry;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PacketCodec
extends ByteToMessageCodec<Packet> {
    private static final Marker marker = MarkerFactory.getMarker("packet_logging");
    private static final Logger log = LoggerFactory.getLogger(PacketCodec.class);
    private final Session session;
    private final boolean client;

    public PacketCodec(Session session, boolean client) {
        this.session = session;
        this.client = client;
    }

    public void encode(ChannelHandlerContext ctx, Packet packet, ByteBuf out) {
        block4: {
            if (log.isTraceEnabled()) {
                log.trace(marker, "Encoding packet: {}", (Object)packet.getClass().getSimpleName());
            }
            int initial = out.writerIndex();
            MinecraftProtocol packetProtocol = this.session.getPacketProtocol();
            PacketRegistry packetRegistry = packetProtocol.getOutboundPacketRegistry();
            try {
                int packetId = this.client ? packetRegistry.getServerboundId(packet) : packetRegistry.getClientboundId(packet);
                PacketDefinition<?> definition = this.client ? packetRegistry.getServerboundDefinition(packetId) : packetRegistry.getClientboundDefinition(packetId);
                packetProtocol.getPacketHeader().writePacketId(out, packetId);
                definition.getSerializer().serialize(out, packet);
                if (log.isDebugEnabled()) {
                    log.debug(marker, "Encoded packet {} ({})", (Object)packet.getClass().getSimpleName(), (Object)packetId);
                }
            }
            catch (Throwable t) {
                log.debug(marker, "Error encoding packet", t);
                out.writerIndex(initial);
                PacketErrorEvent e = new PacketErrorEvent(this.session, t, packet);
                this.session.callEvent(e);
                if (e.shouldSuppress()) break block4;
                throw new EncoderException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) {
        if (buf.readableBytes() == 0) {
            return;
        }
        int initial = buf.readerIndex();
        MinecraftProtocol packetProtocol = this.session.getPacketProtocol();
        PacketRegistry packetRegistry = packetProtocol.getInboundPacketRegistry();
        Packet packet = null;
        try {
            int id = packetProtocol.getPacketHeader().readPacketId(buf);
            if (id == -1) {
                buf.readerIndex(initial);
                return;
            }
            log.trace(marker, "Decoding packet with id: {}", (Object)id);
            Packet packet2 = packet = this.client ? packetRegistry.createClientboundPacket(id, buf) : packetRegistry.createServerboundPacket(id, buf);
            if (buf.readableBytes() > 0) {
                throw new IllegalStateException("Packet \"" + packet.getClass().getSimpleName() + "\" not fully read.");
            }
            out.add(packet);
            if (log.isDebugEnabled()) {
                log.debug(marker, "Decoded packet {} ({})", (Object)packet.getClass().getSimpleName(), (Object)id);
            }
        }
        catch (Throwable t) {
            log.debug(marker, "Error decoding packet", t);
            buf.readerIndex(buf.readerIndex() + buf.readableBytes());
            PacketErrorEvent e = new PacketErrorEvent(this.session, t, packet);
            this.session.callEvent(e);
            if (!e.shouldSuppress()) {
                throw new DecoderException(t);
            }
        }
        finally {
            if (packet != null && packet.isTerminal()) {
                this.session.setAutoRead(false);
            }
        }
    }
}

