/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.common.util.VarInts;

public final class ProtocolUtils {
    private static final int POSITION_X_SIZE = 38;
    private static final int POSITION_Y_SIZE = 12;
    private static final int POSITION_Z_SIZE = 38;
    private static final int POSITION_Y_SHIFT = 4095;
    private static final int POSITION_WRITE_SHIFT = 0x3FFFFFF;

    public static Vector3i readBlockPos(ByteBuf buf) {
        long val = buf.readLong();
        int x = (int)(val >> 38);
        int y = (int)(val << 52 >> 52);
        int z = (int)(val << 26 >> 38);
        return Vector3i.from(x, y, z);
    }

    public static void writeBlockPos(ByteBuf buf, Vector3i pos) {
        long x = pos.getX() & 0x3FFFFFF;
        long y = pos.getY() & 0xFFF;
        long z = pos.getZ() & 0x3FFFFFF;
        buf.writeLong(x << 38 | z << 12 | y);
    }

    public static UUID readUuid(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void writeUuid(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static String readString(ByteBuf buf) {
        int length = VarInts.readUnsignedInt(buf);
        String str = buf.toString(buf.readerIndex(), length, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + length);
        return str;
    }

    public static void writeString(ByteBuf buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        VarInts.writeUnsignedInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }

    private ProtocolUtils() {
    }
}

