/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.CAMPFIRE})
public class CampfireBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        List items = javaNbt.getList("Items", NbtType.COMPOUND);
        if (items != null) {
            for (NbtMap itemTag : items) {
                int slot = itemTag.getByte("Slot") + 1;
                bedrockNbt.put("Item" + slot, (Object)this.getItem(session, itemTag));
            }
        }
    }

    protected NbtMap getItem(GeyserSession session, NbtMap tag) {
        ItemMapping mapping = session.getItemMappings().getMapping(tag.getString("id"));
        if (mapping == null) {
            mapping = ItemMapping.AIR;
        }
        NbtMapBuilder tagBuilder = BedrockItemBuilder.createItemNbt(mapping, tag.getInt("count"), mapping.getBedrockData());
        return tagBuilder.build();
    }
}

