/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConnectionListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.netty.GeyserInjector;
import org.geysermc.geyser.network.netty.LocalServerChannelWrapper;
import org.geysermc.geyser.platform.mod.GeyserChannelGetter;
import org.geysermc.geyser.platform.mod.GeyserModCompressionDisabler;
import org.geysermc.geyser.platform.mod.platform.GeyserModPlatform;

public class GeyserModInjector
extends GeyserInjector {
    private final MinecraftServer server;
    private final GeyserModPlatform platform;
    private DefaultEventLoopGroup eventLoopGroup;
    private List<ChannelFuture> allServerChannels;

    public GeyserModInjector(MinecraftServer server, GeyserModPlatform platform) {
        this.server = server;
        this.platform = platform;
    }

    @Override
    protected void initializeLocalChannel0(final GeyserBootstrap bootstrap) throws Exception {
        ServerConnectionListener connection = this.server.getConnection();
        ChannelFuture listeningChannel = null;
        this.allServerChannels = ((GeyserChannelGetter)connection).geyser$getChannels();
        Iterator<ChannelFuture> iterator = this.allServerChannels.iterator();
        if (iterator.hasNext()) {
            ChannelFuture o;
            listeningChannel = o = iterator.next();
        }
        if (listeningChannel == null) {
            throw new RuntimeException("Unable to find listening channel!");
        }
        final ChannelInitializer<Channel> childHandler = this.getChildHandler(bootstrap, listeningChannel);
        final Method initChannel = childHandler.getClass().getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        this.eventLoopGroup = new DefaultEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("Geyser " + this.platform.platformType().platformName() + " connection thread", 10));
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){

            protected void initChannel(@NonNull Channel ch) throws Exception {
                String baseName;
                initChannel.invoke((Object)childHandler, ch);
                int index = ch.pipeline().names().indexOf("encoder");
                String string = baseName = index != -1 ? "encoder" : "outbound_config";
                if (bootstrap.getGeyserConfig().isDisableCompression()) {
                    ch.pipeline().addAfter(baseName, "geyser-compression-disabler", (ChannelHandler)new GeyserModCompressionDisabler());
                }
            }
        }).group((EventLoopGroup)this.eventLoopGroup).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.allServerChannels.add(channelFuture);
        this.localChannel = channelFuture;
        this.serverSocketAddress = channelFuture.channel().localAddress();
    }

    private ChannelInitializer<Channel> getChildHandler(GeyserBootstrap bootstrap, ChannelFuture listeningChannel) {
        List names = listeningChannel.channel().pipeline().names();
        ChannelInitializer childHandler = null;
        for (String name : names) {
            ChannelHandler handler = listeningChannel.channel().pipeline().get(name);
            try {
                Field childHandlerField = handler.getClass().getDeclaredField("childHandler");
                childHandlerField.setAccessible(true);
                childHandler = (ChannelInitializer)childHandlerField.get(handler);
                break;
            }
            catch (Exception e) {
                if (!bootstrap.getGeyserConfig().isDebugMode()) continue;
                bootstrap.getGeyserLogger().debug("The handler " + name + " isn't a ChannelInitializer. THIS ERROR IS SAFE TO IGNORE!");
                e.printStackTrace();
            }
        }
        if (childHandler == null) {
            throw new RuntimeException();
        }
        return childHandler;
    }

    @Override
    public void shutdown() {
        if (this.allServerChannels != null) {
            this.allServerChannels.remove(this.localChannel);
            this.allServerChannels = null;
        }
        if (this.eventLoopGroup != null) {
            try {
                this.eventLoopGroup.shutdownGracefully().sync();
                this.eventLoopGroup = null;
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error("Unable to shut down injector! " + e.getMessage());
                e.printStackTrace();
            }
        }
        super.shutdown();
    }
}

