/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.enchantment;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.enchantment.EnchantmentComponent;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.session.cache.tags.GeyserHolderSet;
import org.geysermc.geyser.translator.text.MessageTranslator;

public record Enchantment(Set<EnchantmentComponent> effects, GeyserHolderSet<Item> supportedItems, int maxLevel, String description, int anvilCost, GeyserHolderSet<Enchantment> exclusiveSet, @Nullable BedrockEnchantment bedrockEnchantment) {
    public static Enchantment read(RegistryEntryContext context) {
        NbtMap data = context.data();
        Set<EnchantmentComponent> effects = Enchantment.readEnchantmentComponents(data.getCompound("effects"));
        GeyserHolderSet<Item> supportedItems = GeyserHolderSet.readHolderSet(context.session(), JavaRegistries.ITEM, data.get((Object)"supported_items"));
        int maxLevel = data.getInt("max_level");
        int anvilCost = data.getInt("anvil_cost");
        GeyserHolderSet<Enchantment> exclusiveSet = GeyserHolderSet.readHolderSet(JavaRegistries.ENCHANTMENT, data.get((Object)"exclusive_set"), context::getNetworkId);
        BedrockEnchantment bedrockEnchantment = BedrockEnchantment.getByJavaIdentifier(context.id().asString());
        String description = bedrockEnchantment == null ? MessageTranslator.deserializeDescription(context.session(), data) : null;
        return new Enchantment(effects, supportedItems, maxLevel, description, anvilCost, exclusiveSet, bedrockEnchantment);
    }

    private static Set<EnchantmentComponent> readEnchantmentComponents(NbtMap effects) {
        HashSet<EnchantmentComponent> components = new HashSet<EnchantmentComponent>();
        for (Map.Entry entry : effects.entrySet()) {
            switch ((String)entry.getKey()) {
                case "minecraft:prevent_armor_change": {
                    components.add(EnchantmentComponent.PREVENT_ARMOR_CHANGE);
                }
            }
        }
        return Set.copyOf(components);
    }
}

