/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension.event;

import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.Event;
import org.geysermc.event.FireResult;
import org.geysermc.event.PostOrder;
import org.geysermc.event.subscribe.Subscriber;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.EventSubscriber;
import org.geysermc.geyser.api.event.ExtensionEventBus;
import org.geysermc.geyser.api.extension.Extension;

public record GeyserExtensionEventBus(EventBus<EventRegistrar> eventBus, Extension extension) implements ExtensionEventBus
{
    public void unsubscribe(@NonNull EventSubscriber<Extension, ? extends Event> subscription) {
        this.eventBus.unsubscribe((Subscriber)subscription);
    }

    public FireResult fire(@NonNull Event event) {
        return this.eventBus.fire(event);
    }

    public FireResult fireSilently(@NonNull Event event) {
        return this.eventBus.fireSilently(event);
    }

    @Override
    public <T extends Event> @NonNull Set<? extends EventSubscriber<EventRegistrar, T>> subscribers(@NonNull Class<T> eventClass) {
        return this.eventBus.subscribers(eventClass);
    }

    public void register(@NonNull Object listener) {
        this.eventBus.register(this.extension, listener);
    }

    public <T extends Event, U extends Subscriber<T>> @NonNull U subscribe(@NonNull Class<T> eventClass, @NonNull Consumer<T> consumer) {
        return (U)this.eventBus.subscribe(this.extension, eventClass, consumer);
    }

    public <T extends Event, U extends Subscriber<T>> @NonNull U subscribe(@NonNull Class<T> eventClass, @NonNull Consumer<T> consumer, @NonNull PostOrder postOrder) {
        return (U)this.eventBus.subscribe(this.extension, eventClass, consumer, postOrder);
    }

    public void unregisterAll() {
        this.eventBus.unregisterAll(this.extension);
    }
}

