/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.GolemEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;

public class ShulkerEntity
extends GolemEntity {
    public ShulkerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.setFlag(EntityFlag.BRIBED, true);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, 16);
        this.setFlag(EntityFlag.COLLIDABLE, true);
        this.setFlag(EntityFlag.RENDER_WHEN_INVISIBLE, true);
    }

    public void setAttachedFace(EntityMetadata<Direction, ?> entityMetadata) {
        Direction direction = (Direction)entityMetadata.getValue();
        this.dirtyMetadata.put(EntityDataTypes.SHULKER_ATTACH_FACE, direction.ordinal());
    }

    public void setShulkerHeight(ByteEntityMetadata entityMetadata) {
        byte height = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityDataTypes.SHULKER_PEEK_AMOUNT, Integer.valueOf(height));
    }

    public void setShulkerColor(ByteEntityMetadata entityMetadata) {
        byte color = entityMetadata.getPrimitiveValue();
        if (color == 16) {
            this.dirtyMetadata.put(EntityDataTypes.VARIANT, 16);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.VARIANT, Math.abs(color - 15));
        }
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }
}

