/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.WobbleStyle;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BellValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BellValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BlockValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BlockValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.ChestValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.ChestValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.DecoratedPotValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.DecoratedPotValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.EndGatewayValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.EndGatewayValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.GenericBlockValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.GenericBlockValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.MobSpawnerValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.MobSpawnerValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.NoteBlockValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.NoteBlockValueType;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientboundBlockEventPacket
implements MinecraftPacket {
    private static final int NOTE_BLOCK = 109;
    private static final int STICKY_PISTON = 128;
    private static final int PISTON = 138;
    private static final int MOB_SPAWNER = 197;
    private static final int CHEST = 200;
    private static final int ENDER_CHEST = 399;
    private static final int TRAPPED_CHEST = 468;
    private static final int END_GATEWAY = 665;
    private static final int SHULKER_BOX_LOWER = 675;
    private static final int SHULKER_BOX_HIGHER = 691;
    private static final int BELL = 846;
    private static final int DECORATED_POT = 1153;
    private static final Logger log = LoggerFactory.getLogger(ClientboundBlockEventPacket.class);
    @NonNull
    private final Vector3i position;
    private final int rawType;
    private final int rawValue;
    private @Nullable BlockValueType type;
    private @Nullable BlockValue value;
    private final int blockId;

    public ClientboundBlockEventPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.rawType = in.readUnsignedByte();
        this.rawValue = in.readUnsignedByte();
        this.blockId = MinecraftTypes.readVarInt(in);
        try {
            if (this.blockId == 109) {
                this.type = NoteBlockValueType.from(this.rawType);
                this.value = new NoteBlockValue();
            } else if (this.blockId == 128 || this.blockId == 138) {
                this.type = PistonValueType.from(this.rawType);
                this.value = new PistonValue(Direction.from(Math.abs((this.rawValue & 7) % 6)));
            } else if (this.blockId == 197) {
                this.type = MobSpawnerValueType.from(this.rawType - 1);
                this.value = new MobSpawnerValue();
            } else if (this.blockId == 200 || this.blockId == 399 || this.blockId == 468 || this.blockId >= 675 && this.blockId <= 691) {
                this.type = ChestValueType.from(this.rawType - 1);
                this.value = new ChestValue(this.rawValue);
            } else if (this.blockId == 665) {
                this.type = EndGatewayValueType.from(this.rawType - 1);
                this.value = new EndGatewayValue();
            } else if (this.blockId == 846) {
                this.type = BellValueType.from(this.rawType - 1);
                this.value = new BellValue(Direction.from(Math.abs(this.rawValue % 6)));
            } else if (this.blockId == 1153) {
                this.type = DecoratedPotValueType.from(this.rawType - 1);
                this.value = new DecoratedPotValue(WobbleStyle.from(Math.abs(this.rawValue % 2)));
            } else {
                this.type = GenericBlockValueType.from(this.rawType);
                this.value = new GenericBlockValue(this.rawValue);
            }
        }
        catch (Throwable t) {
            this.type = null;
            this.value = null;
            log.warn("Unable to deserialize type and value! Message: {} (block: {}, type: {}, value: {})", t.getMessage(), this.blockId, this.rawType, this.rawValue);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        out.writeByte(this.rawType);
        out.writeByte(this.rawValue);
        MinecraftTypes.writeVarInt(out, this.blockId);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public int getRawType() {
        return this.rawType;
    }

    public int getRawValue() {
        return this.rawValue;
    }

    public @Nullable BlockValueType getType() {
        return this.type;
    }

    public @Nullable BlockValue getValue() {
        return this.value;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setType(@Nullable BlockValueType type) {
        this.type = type;
    }

    public void setValue(@Nullable BlockValue value) {
        this.value = value;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockEventPacket)) {
            return false;
        }
        ClientboundBlockEventPacket other = (ClientboundBlockEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRawType() != other.getRawType()) {
            return false;
        }
        if (this.getRawValue() != other.getRawValue()) {
            return false;
        }
        if (this.getBlockId() != other.getBlockId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockValueType this$type = this.getType();
        BlockValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BlockValue this$value = this.getValue();
        BlockValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundBlockEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRawType();
        result = result * 59 + this.getRawValue();
        result = result * 59 + this.getBlockId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BlockValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "ClientboundBlockEventPacket(position=" + String.valueOf(this.getPosition()) + ", rawType=" + this.getRawType() + ", rawValue=" + this.getRawValue() + ", type=" + String.valueOf(this.getType()) + ", value=" + String.valueOf(this.getValue()) + ", blockId=" + this.getBlockId() + ")";
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockEventPacket(position, this.rawType, this.rawValue, this.type, this.value, this.blockId);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withRawType(int rawType) {
        return this.rawType == rawType ? this : new ClientboundBlockEventPacket(this.position, rawType, this.rawValue, this.type, this.value, this.blockId);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withRawValue(int rawValue) {
        return this.rawValue == rawValue ? this : new ClientboundBlockEventPacket(this.position, this.rawType, rawValue, this.type, this.value, this.blockId);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withType(@Nullable BlockValueType type) {
        return this.type == type ? this : new ClientboundBlockEventPacket(this.position, this.rawType, this.rawValue, type, this.value, this.blockId);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withValue(@Nullable BlockValue value) {
        return this.value == value ? this : new ClientboundBlockEventPacket(this.position, this.rawType, this.rawValue, this.type, value, this.blockId);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundBlockEventPacket withBlockId(int blockId) {
        return this.blockId == blockId ? this : new ClientboundBlockEventPacket(this.position, this.rawType, this.rawValue, this.type, this.value, blockId);
    }

    public ClientboundBlockEventPacket(@NonNull Vector3i position, int rawType, int rawValue, @Nullable BlockValueType type, @Nullable BlockValue value, int blockId) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.rawType = rawType;
        this.rawValue = rawValue;
        this.type = type;
        this.value = value;
        this.blockId = blockId;
    }
}

