/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.factory;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.network.ProxyInfo;
import org.geysermc.mcprotocollib.network.netty.DefaultPacketHandlerExecutor;
import org.geysermc.mcprotocollib.network.session.ClientNetworkSession;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;

public final class ClientNetworkSessionFactory {
    private SocketAddress remoteSocketAddress;
    private MinecraftProtocol protocol;
    private Executor packetHandlerExecutor;
    private SocketAddress bindSocketAddress;
    private ProxyInfo proxy;

    public static ClientNetworkSessionFactory factory() {
        return new ClientNetworkSessionFactory();
    }

    public ClientNetworkSessionFactory setAddress(String address) {
        return this.setAddress(address, 25565);
    }

    public ClientNetworkSessionFactory setAddress(String address, int port) {
        return this.setRemoteSocketAddress(InetSocketAddress.createUnresolved(address, port));
    }

    public ClientNetworkSessionFactory setBindAddress(String bindAddress) {
        return this.setBindAddress(bindAddress, 0);
    }

    public ClientNetworkSessionFactory setBindAddress(String bindAddress, int port) {
        return this.setRemoteSocketAddress(InetSocketAddress.createUnresolved(bindAddress, port));
    }

    public ClientNetworkSession create() {
        return new ClientNetworkSession(Objects.requireNonNull(this.remoteSocketAddress, "socketRemoteAddress"), Objects.requireNonNull(this.protocol, "protocol"), Objects.requireNonNullElseGet(this.packetHandlerExecutor, DefaultPacketHandlerExecutor::createExecutor), this.bindSocketAddress, this.proxy);
    }

    public @NonNull ClientNetworkSessionFactory setRemoteSocketAddress(SocketAddress remoteSocketAddress) {
        this.remoteSocketAddress = remoteSocketAddress;
        return this;
    }

    public @NonNull ClientNetworkSessionFactory setProtocol(MinecraftProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public @NonNull ClientNetworkSessionFactory setPacketHandlerExecutor(Executor packetHandlerExecutor) {
        this.packetHandlerExecutor = packetHandlerExecutor;
        return this;
    }

    public @NonNull ClientNetworkSessionFactory setBindSocketAddress(SocketAddress bindSocketAddress) {
        this.bindSocketAddress = bindSocketAddress;
        return this;
    }

    public @NonNull ClientNetworkSessionFactory setProxy(ProxyInfo proxy) {
        this.proxy = proxy;
        return this;
    }

    private ClientNetworkSessionFactory() {
    }
}

