/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.net.UnknownHostException;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.ComponentLike;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TextReplacementConfig;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.event.ClickEvent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextDecoration;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.WebUtils;

public final class VersionCheckUtils {
    private static @NonNull OptionalInt LATEST_BEDROCK_RELEASE = OptionalInt.empty();
    private static final int SUPPORTED_JAVA_VERSION = 17;

    public static void checkForOutdatedFloodgate(GeyserLogger logger) {
        try {
            Class.forName("org.geysermc.floodgate.util.TimeSyncerHolder");
            logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.outdated", "https://geysermc.org/download#floodgate"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void checkForOutdatedJava(GeyserLogger logger) {
        int majorVersion;
        String javaVersion = System.getProperty("java.version");
        Matcher matcher = Pattern.compile("(?:1\\.)?(\\d+)").matcher(javaVersion);
        if (!matcher.find()) {
            logger.debug("Could not parse Java version string " + javaVersion);
            return;
        }
        String version = matcher.group(1);
        try {
            majorVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            logger.debug("Could not format as an int: " + version);
            return;
        }
        if (majorVersion < 17) {
            logger.warning("*********************************************");
            logger.warning("");
            logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_java.header"));
            logger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_java.message", 17, javaVersion));
            logger.warning("");
            logger.warning("*********************************************");
        }
    }

    public static void checkForGeyserUpdate(Supplier<GeyserCommandSource> recipient) {
        CompletableFuture.runAsync(() -> {
            try {
                JsonNode json = WebUtils.getJson("https://api.geysermc.org/v2/versions/geyser");
                JsonNode bedrock = json.get("bedrock").get("protocol");
                int protocolVersion = bedrock.get("id").asInt();
                if (GameProtocol.getBedrockCodec(protocolVersion) != null) {
                    LATEST_BEDROCK_RELEASE = OptionalInt.empty();
                    return;
                }
                LATEST_BEDROCK_RELEASE = OptionalInt.of(protocolVersion);
                String newBedrockVersion = bedrock.get("name").asText();
                GeyserCommandSource sender = (GeyserCommandSource)recipient.get();
                Object message = ((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GREEN)).append(Component.text(GeyserLocale.getPlayerLocaleString("geyser.version.new", sender.locale(), newBedrockVersion)).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{1\\}").replacement((ComponentLike)((Object)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("https://geysermc.org/download").color(NamedTextColor.BLUE)).decoration(TextDecoration.UNDERLINED, TextDecoration.State.TRUE)).clickEvent(ClickEvent.openUrl("https://geysermc.org/download")))).build()))).build();
                sender.sendMessage((Component)message);
            }
            catch (UnknownHostException e) {
                GeyserImpl.getInstance().getLogger().error("Unable to resolve Geyser api! Cannot check for Geyser updates.");
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error("Error whilst checking for Geyser update!", e);
            }
        });
    }

    public static @NonNull OptionalInt getLatestBedrockRelease() {
        return LATEST_BEDROCK_RELEASE;
    }

    private VersionCheckUtils() {
    }
}

