/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoRegistration;

public class IoHandlerWrapper
implements IoHandler {
    private final IoHandler localHandler;
    private final IoHandler nativeHandler;
    private final IoHandlerContextWrapper contextWrapper = new IoHandlerContextWrapper();
    private static final Class<? extends IoHandle> LOCAL_HANDLER_CLASS;

    public IoHandlerWrapper(IoHandler localHandler, IoHandler nativeHandler) {
        this.localHandler = localHandler;
        this.nativeHandler = nativeHandler;
    }

    public void initialize() {
        this.localHandler.initialize();
        this.nativeHandler.initialize();
    }

    public int run(IoHandlerContext context) {
        this.contextWrapper.base = context;
        this.localHandler.run((IoHandlerContext)this.contextWrapper);
        return this.nativeHandler.run(context);
    }

    public void prepareToDestroy() {
        this.localHandler.prepareToDestroy();
        this.nativeHandler.prepareToDestroy();
    }

    public void destroy() {
        this.localHandler.destroy();
        this.nativeHandler.destroy();
    }

    public IoRegistration register(IoHandle handle) throws Exception {
        if (LOCAL_HANDLER_CLASS.isAssignableFrom(handle.getClass())) {
            return this.localHandler.register(handle);
        }
        return this.nativeHandler.register(handle);
    }

    public void wakeup() {
        this.localHandler.wakeup();
        this.nativeHandler.wakeup();
    }

    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.localHandler.isCompatible(handleType) || this.nativeHandler.isCompatible(handleType);
    }

    static {
        try {
            LOCAL_HANDLER_CLASS = Class.forName("io.netty.channel.local.LocalIoHandle");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class IoHandlerContextWrapper
    implements IoHandlerContext {
        private IoHandlerContext base;

        private IoHandlerContextWrapper() {
        }

        public boolean canBlock() {
            return false;
        }

        public long delayNanos(long currentTimeNanos) {
            return this.base.delayNanos(currentTimeNanos);
        }

        public long deadlineNanos() {
            return this.base.deadlineNanos();
        }
    }
}

