/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.session.GeyserSession;

public class MinecraftHashEncoder {
    private static final byte TAG_EMPTY = 1;
    private static final byte TAG_MAP_START = 2;
    private static final byte TAG_MAP_END = 3;
    private static final byte TAG_LIST_START = 4;
    private static final byte TAG_LIST_END = 5;
    private static final byte TAG_BYTE = 6;
    private static final byte TAG_SHORT = 7;
    private static final byte TAG_INT = 8;
    private static final byte TAG_LONG = 9;
    private static final byte TAG_FLOAT = 10;
    private static final byte TAG_DOUBLE = 11;
    private static final byte TAG_STRING = 12;
    private static final byte TAG_BOOLEAN = 13;
    private static final byte TAG_BYTE_ARRAY_START = 14;
    private static final byte TAG_BYTE_ARRAY_END = 15;
    private static final byte TAG_INT_ARRAY_START = 16;
    private static final byte TAG_INT_ARRAY_END = 17;
    private static final byte TAG_LONG_ARRAY_START = 18;
    private static final byte TAG_LONG_ARRAY_END = 19;
    private static final Comparator<HashCode> HASH_COMPARATOR = Comparator.comparingLong(HashCode::padToLong);
    private static final Comparator<Map.Entry<HashCode, HashCode>> MAP_ENTRY_ORDER = Map.Entry.comparingByKey(HASH_COMPARATOR).thenComparing(Map.Entry.comparingByValue(HASH_COMPARATOR));
    private static final byte[] EMPTY = new byte[]{1};
    public static final byte[] EMPTY_MAP = new byte[]{2, 3};
    private static final byte[] FALSE = new byte[]{13, 0};
    private static final byte[] TRUE = new byte[]{13, 1};
    private final HashFunction hasher = Hashing.crc32c();
    private final GeyserSession session;
    private final HashCode empty;
    private final HashCode emptyMap;
    private final HashCode falseHash;
    private final HashCode trueHash;

    public MinecraftHashEncoder(GeyserSession session) {
        this.session = session;
        this.empty = this.hasher.hashBytes(EMPTY);
        this.emptyMap = this.hasher.hashBytes(EMPTY_MAP);
        this.falseHash = this.hasher.hashBytes(FALSE);
        this.trueHash = this.hasher.hashBytes(TRUE);
    }

    public GeyserSession session() {
        return this.session;
    }

    public HashCode empty() {
        return this.empty;
    }

    public HashCode emptyMap() {
        return this.emptyMap;
    }

    public HashCode number(Number number) {
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return this.hasher.newHasher(2).putByte((byte)6).putByte(b.byteValue()).hash();
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return this.hasher.newHasher(3).putByte((byte)7).putShort(s.shortValue()).hash();
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return this.hasher.newHasher(5).putByte((byte)8).putInt(i.intValue()).hash();
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return this.hasher.newHasher(9).putByte((byte)9).putLong(l.longValue()).hash();
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return this.hasher.newHasher(5).putByte((byte)10).putFloat(f.floatValue()).hash();
        }
        return this.hasher.newHasher(9).putByte((byte)11).putDouble(number.doubleValue()).hash();
    }

    public HashCode string(String string) {
        return this.hasher.newHasher().putByte((byte)12).putInt(string.length()).putUnencodedChars((CharSequence)string).hash();
    }

    public HashCode bool(boolean b) {
        return b ? this.trueHash : this.falseHash;
    }

    public HashCode map(Map<HashCode, HashCode> map) {
        Hasher mapHasher = this.hasher.newHasher();
        mapHasher.putByte((byte)2);
        map.entrySet().stream().sorted(MAP_ENTRY_ORDER).forEach(entry -> mapHasher.putBytes(((HashCode)entry.getKey()).asBytes()).putBytes(((HashCode)entry.getValue()).asBytes()));
        mapHasher.putByte((byte)3);
        return mapHasher.hash();
    }

    public HashCode nbtMap(NbtMap map) {
        HashMap<HashCode, HashCode> hashed = new HashMap<HashCode, HashCode>();
        for (String key : map.keySet()) {
            HashCode hashedKey = this.string(key);
            Object value = map.get(key);
            if (value instanceof NbtList) {
                NbtList list = (NbtList)value;
                hashed.put(hashedKey, this.nbtList(list));
                continue;
            }
            map.listenForNumber(key, n -> hashed.put(hashedKey, this.number(n)));
            map.listenForString(key, s -> hashed.put(hashedKey, this.string((String)s)));
            map.listenForCompound(key, compound -> hashed.put(hashedKey, this.nbtMap((NbtMap)compound)));
            map.listenForByteArray(key, bytes -> hashed.put(hashedKey, this.byteArray((byte[])bytes)));
            map.listenForIntArray(key, ints -> hashed.put(hashedKey, this.intArray((int[])ints)));
            map.listenForLongArray(key, longs -> hashed.put(hashedKey, this.longArray((long[])longs)));
        }
        return this.map(hashed);
    }

    public HashCode list(List<HashCode> list) {
        Hasher listHasher = this.hasher.newHasher();
        listHasher.putByte((byte)4);
        list.forEach(hash -> listHasher.putBytes(hash.asBytes()));
        listHasher.putByte((byte)5);
        return listHasher.hash();
    }

    public HashCode nbtList(NbtList<?> nbtList) {
        ArrayList<HashCode> hashed;
        block3: {
            NbtType<?> type;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            type = nbtList.getType();
                                            hashed = new ArrayList<HashCode>();
                                            if (type != NbtType.BYTE) break block2;
                                            hashed.addAll(nbtList.stream().map(this::number).toList());
                                            break block3;
                                        }
                                        if (type != NbtType.SHORT) break block4;
                                        hashed.addAll(nbtList.stream().map(this::number).toList());
                                        break block3;
                                    }
                                    if (type != NbtType.INT) break block5;
                                    hashed.addAll(nbtList.stream().map(this::number).toList());
                                    break block3;
                                }
                                if (type != NbtType.LONG) break block6;
                                hashed.addAll(nbtList.stream().map(this::number).toList());
                                break block3;
                            }
                            if (type != NbtType.FLOAT) break block7;
                            hashed.addAll(nbtList.stream().map(this::number).toList());
                            break block3;
                        }
                        if (type != NbtType.DOUBLE) break block8;
                        hashed.addAll(nbtList.stream().map(this::number).toList());
                        break block3;
                    }
                    if (type != NbtType.STRING) break block9;
                    hashed.addAll(nbtList.stream().map(this::string).toList());
                    break block3;
                }
                if (type != NbtType.LIST) break block10;
                for (NbtList list : nbtList) {
                    hashed.add(this.nbtList(list));
                }
                break block3;
            }
            if (type != NbtType.COMPOUND) break block3;
            for (NbtMap compound : nbtList) {
                hashed.add(this.nbtMap(compound));
            }
        }
        return this.list(hashed);
    }

    public HashCode byteArray(byte[] bytes) {
        Hasher arrayHasher = this.hasher.newHasher();
        arrayHasher.putByte((byte)14);
        arrayHasher.putBytes(bytes);
        arrayHasher.putByte((byte)15);
        return arrayHasher.hash();
    }

    public HashCode intArray(int[] ints) {
        Hasher arrayHasher = this.hasher.newHasher();
        arrayHasher.putByte((byte)16);
        for (int i : ints) {
            arrayHasher.putInt(i);
        }
        arrayHasher.putByte((byte)17);
        return arrayHasher.hash();
    }

    public HashCode longArray(long[] longs) {
        Hasher arrayHasher = this.hasher.newHasher();
        arrayHasher.putByte((byte)18);
        for (long l : longs) {
            arrayHasher.putLong(l);
        }
        arrayHasher.putByte((byte)19);
        return arrayHasher.hash();
    }
}

