/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.event.type;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineResourcePacksEvent;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.exception.ResourcePackException;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.ResourcePackHolder;

public class GeyserDefineResourcePacksEventImpl
extends GeyserDefineResourcePacksEvent {
    private final Map<UUID, ResourcePackHolder> packs;

    public GeyserDefineResourcePacksEventImpl(Map<UUID, ResourcePackHolder> packMap) {
        this.packs = packMap;
    }

    @Override
    public @NonNull List<ResourcePack> resourcePacks() {
        return this.packs.values().stream().map(ResourcePackHolder::resourcePack).toList();
    }

    @Override
    public void register(@NonNull ResourcePack resourcePack, ResourcePackOption<?> ... options) {
        Objects.requireNonNull(resourcePack, "resource pack must not be null!");
        if (!(resourcePack instanceof GeyserResourcePack)) {
            throw new ResourcePackException(ResourcePackException.Cause.UNKNOWN_IMPLEMENTATION);
        }
        GeyserResourcePack pack = (GeyserResourcePack)resourcePack;
        UUID uuid = resourcePack.uuid();
        if (this.packs.containsKey(uuid)) {
            throw new ResourcePackException(ResourcePackException.Cause.DUPLICATE);
        }
        ResourcePackHolder holder = ResourcePackHolder.of(pack);
        this.attemptRegisterOptions(holder, options);
        this.packs.put(uuid, holder);
    }

    @Override
    public void registerOptions(@NonNull UUID uuid, ResourcePackOption<?> ... options) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(options);
        ResourcePackHolder holder = this.packs.get(uuid);
        if (holder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        this.attemptRegisterOptions(holder, options);
    }

    @Override
    public Collection<ResourcePackOption<?>> options(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid);
        ResourcePackHolder packHolder = this.packs.get(uuid);
        if (packHolder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        return packHolder.optionHolder().immutableValues();
    }

    @Override
    public @Nullable ResourcePackOption<?> option(@NonNull UUID uuid, @NonNull ResourcePackOption.Type type) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(type);
        ResourcePackHolder packHolder = this.packs.get(uuid);
        if (packHolder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        return (ResourcePackOption)packHolder.optionHolder().get((Object)type);
    }

    @Override
    public void unregister(@NonNull UUID uuid) {
        this.packs.remove(uuid);
    }

    private void attemptRegisterOptions(@NonNull ResourcePackHolder holder, ResourcePackOption<?> ... options) {
        if (options == null) {
            return;
        }
        holder.optionHolder().validateAndAdd(holder.pack(), options);
    }

    public Map<UUID, ResourcePackHolder> getPacks() {
        return this.packs;
    }
}

