/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.CommandBlockMode;

public class ServerboundSetCommandBlockPacket
implements MinecraftPacket {
    private static final int FLAG_TRACK_OUTPUT = 1;
    private static final int FLAG_CONDITIONAL = 2;
    private static final int FLAG_AUTOMATIC = 4;
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final String command;
    @lombok.NonNull
    private final CommandBlockMode mode;
    private final boolean doesTrackOutput;
    private final boolean conditional;
    private final boolean automatic;

    public ServerboundSetCommandBlockPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.command = MinecraftTypes.readString(in);
        this.mode = CommandBlockMode.from(MinecraftTypes.readVarInt(in));
        short flags = in.readUnsignedByte();
        this.doesTrackOutput = (flags & 1) != 0;
        this.conditional = (flags & 2) != 0;
        this.automatic = (flags & 4) != 0;
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        MinecraftTypes.writeString(out, this.command);
        MinecraftTypes.writeVarInt(out, this.mode.ordinal());
        int flags = 0;
        if (this.doesTrackOutput) {
            flags |= 1;
        }
        if (this.conditional) {
            flags |= 2;
        }
        if (this.automatic) {
            flags |= 4;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public String getCommand() {
        return this.command;
    }

    @lombok.NonNull
    public CommandBlockMode getMode() {
        return this.mode;
    }

    public boolean isDoesTrackOutput() {
        return this.doesTrackOutput;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetCommandBlockPacket)) {
            return false;
        }
        ServerboundSetCommandBlockPacket other = (ServerboundSetCommandBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDoesTrackOutput() != other.isDoesTrackOutput()) {
            return false;
        }
        if (this.isConditional() != other.isConditional()) {
            return false;
        }
        if (this.isAutomatic() != other.isAutomatic()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        CommandBlockMode this$mode = this.getMode();
        CommandBlockMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetCommandBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDoesTrackOutput() ? 79 : 97);
        result = result * 59 + (this.isConditional() ? 79 : 97);
        result = result * 59 + (this.isAutomatic() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        CommandBlockMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetCommandBlockPacket(position=" + String.valueOf(this.getPosition()) + ", command=" + this.getCommand() + ", mode=" + String.valueOf((Object)this.getMode()) + ", doesTrackOutput=" + this.isDoesTrackOutput() + ", conditional=" + this.isConditional() + ", automatic=" + this.isAutomatic() + ")";
    }

    public @NonNull ServerboundSetCommandBlockPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSetCommandBlockPacket(position, this.command, this.mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public @NonNull ServerboundSetCommandBlockPacket withCommand(@lombok.NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.command == command ? this : new ServerboundSetCommandBlockPacket(this.position, command, this.mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public @NonNull ServerboundSetCommandBlockPacket withMode(@lombok.NonNull CommandBlockMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.mode == mode ? this : new ServerboundSetCommandBlockPacket(this.position, this.command, mode, this.doesTrackOutput, this.conditional, this.automatic);
    }

    public @NonNull ServerboundSetCommandBlockPacket withDoesTrackOutput(boolean doesTrackOutput) {
        return this.doesTrackOutput == doesTrackOutput ? this : new ServerboundSetCommandBlockPacket(this.position, this.command, this.mode, doesTrackOutput, this.conditional, this.automatic);
    }

    public @NonNull ServerboundSetCommandBlockPacket withConditional(boolean conditional) {
        return this.conditional == conditional ? this : new ServerboundSetCommandBlockPacket(this.position, this.command, this.mode, this.doesTrackOutput, conditional, this.automatic);
    }

    public @NonNull ServerboundSetCommandBlockPacket withAutomatic(boolean automatic) {
        return this.automatic == automatic ? this : new ServerboundSetCommandBlockPacket(this.position, this.command, this.mode, this.doesTrackOutput, this.conditional, automatic);
    }

    public ServerboundSetCommandBlockPacket(@lombok.NonNull Vector3i position, @lombok.NonNull String command, @lombok.NonNull CommandBlockMode mode, boolean doesTrackOutput, boolean conditional, boolean automatic) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.position = position;
        this.command = command;
        this.mode = mode;
        this.doesTrackOutput = doesTrackOutput;
        this.conditional = conditional;
        this.automatic = automatic;
    }
}

