/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.CraftingBookStateType;

public class ClientboundRecipeBookSettingsPacket
implements MinecraftPacket {
    private final Map<CraftingBookStateType, TypeSettings> states;

    public ClientboundRecipeBookSettingsPacket(ByteBuf in) {
        this.states = new EnumMap<CraftingBookStateType, TypeSettings>(CraftingBookStateType.class);
        for (CraftingBookStateType type : CraftingBookStateType.values()) {
            boolean open = in.readBoolean();
            boolean filtering = in.readBoolean();
            if (!open && !filtering) continue;
            this.states.put(type, new TypeSettings(open, filtering));
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        for (CraftingBookStateType type : CraftingBookStateType.values()) {
            TypeSettings typeSettings = this.states.get((Object)type);
            buf.writeBoolean(typeSettings == null ? false : typeSettings.open());
            buf.writeBoolean(typeSettings == null ? false : typeSettings.filtering());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Map<CraftingBookStateType, TypeSettings> getStates() {
        return this.states;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRecipeBookSettingsPacket)) {
            return false;
        }
        ClientboundRecipeBookSettingsPacket other = (ClientboundRecipeBookSettingsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<CraftingBookStateType, TypeSettings> this$states = this.getStates();
        Map<CraftingBookStateType, TypeSettings> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRecipeBookSettingsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<CraftingBookStateType, TypeSettings> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRecipeBookSettingsPacket(states=" + String.valueOf(this.getStates()) + ")";
    }

    public @NonNull ClientboundRecipeBookSettingsPacket withStates(Map<CraftingBookStateType, TypeSettings> states) {
        return this.states == states ? this : new ClientboundRecipeBookSettingsPacket(states);
    }

    public ClientboundRecipeBookSettingsPacket(Map<CraftingBookStateType, TypeSettings> states) {
        this.states = states;
    }

    private record TypeSettings(boolean open, boolean filtering) {
    }
}

