/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatFilterType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.MessageSignature;

public class ClientboundPlayerChatPacket
implements MinecraftPacket {
    private final int globalIndex;
    private final UUID sender;
    private final int index;
    private final byte @Nullable [] messageSignature;
    private final String content;
    private final long timeStamp;
    private final long salt;
    private final List<MessageSignature> lastSeenMessages;
    private final @Nullable Component unsignedContent;
    private final ChatFilterType filterMask;
    private final Holder<ChatType> chatType;
    private final Component name;
    private final @Nullable Component targetName;

    public ClientboundPlayerChatPacket(ByteBuf in) {
        this.globalIndex = MinecraftTypes.readVarInt(in);
        this.sender = MinecraftTypes.readUUID(in);
        this.index = MinecraftTypes.readVarInt(in);
        this.messageSignature = MinecraftTypes.readNullable(in, buf -> {
            byte[] signature = new byte[256];
            buf.readBytes(signature);
            return signature;
        });
        this.content = MinecraftTypes.readString(in, 256);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.lastSeenMessages = new ArrayList<MessageSignature>();
        int seenMessageCount = Math.min(MinecraftTypes.readVarInt(in), 20);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(MessageSignature.read(in));
        }
        this.unsignedContent = MinecraftTypes.readNullable(in, MinecraftTypes::readComponent);
        this.filterMask = ChatFilterType.from(MinecraftTypes.readVarInt(in));
        this.chatType = MinecraftTypes.readHolder(in, MinecraftTypes::readChatType);
        this.name = MinecraftTypes.readComponent(in);
        this.targetName = MinecraftTypes.readNullable(in, MinecraftTypes::readComponent);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.globalIndex);
        MinecraftTypes.writeUUID(out, this.sender);
        MinecraftTypes.writeVarInt(out, this.index);
        MinecraftTypes.writeNullable(out, this.messageSignature, ByteBuf::writeBytes);
        MinecraftTypes.writeString(out, this.content);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        MinecraftTypes.writeVarInt(out, this.lastSeenMessages.size());
        for (MessageSignature messageSignature : this.lastSeenMessages) {
            MinecraftTypes.writeVarInt(out, messageSignature.getId() + 1);
            if (messageSignature.getMessageSignature() == null) continue;
            out.writeBytes(messageSignature.getMessageSignature());
        }
        MinecraftTypes.writeNullable(out, this.unsignedContent, MinecraftTypes::writeComponent);
        MinecraftTypes.writeVarInt(out, this.filterMask.ordinal());
        MinecraftTypes.writeHolder(out, this.chatType, MinecraftTypes::writeChatType);
        MinecraftTypes.writeComponent(out, this.name);
        MinecraftTypes.writeNullable(out, this.targetName, MinecraftTypes::writeComponent);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getGlobalIndex() {
        return this.globalIndex;
    }

    public UUID getSender() {
        return this.sender;
    }

    public int getIndex() {
        return this.index;
    }

    public byte @Nullable [] getMessageSignature() {
        return this.messageSignature;
    }

    public String getContent() {
        return this.content;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<MessageSignature> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    public @Nullable Component getUnsignedContent() {
        return this.unsignedContent;
    }

    public ChatFilterType getFilterMask() {
        return this.filterMask;
    }

    public Holder<ChatType> getChatType() {
        return this.chatType;
    }

    public Component getName() {
        return this.name;
    }

    public @Nullable Component getTargetName() {
        return this.targetName;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerChatPacket)) {
            return false;
        }
        ClientboundPlayerChatPacket other = (ClientboundPlayerChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGlobalIndex() != other.getGlobalIndex()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        if (!Arrays.equals(this.getMessageSignature(), other.getMessageSignature())) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<MessageSignature> this$lastSeenMessages = this.getLastSeenMessages();
        List<MessageSignature> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        Component this$unsignedContent = this.getUnsignedContent();
        Component other$unsignedContent = other.getUnsignedContent();
        if (this$unsignedContent == null ? other$unsignedContent != null : !this$unsignedContent.equals(other$unsignedContent)) {
            return false;
        }
        ChatFilterType this$filterMask = this.getFilterMask();
        ChatFilterType other$filterMask = other.getFilterMask();
        if (this$filterMask == null ? other$filterMask != null : !((Object)((Object)this$filterMask)).equals((Object)other$filterMask)) {
            return false;
        }
        Holder<ChatType> this$chatType = this.getChatType();
        Holder<ChatType> other$chatType = other.getChatType();
        if (this$chatType == null ? other$chatType != null : !this$chatType.equals(other$chatType)) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$targetName = this.getTargetName();
        Component other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGlobalIndex();
        result = result * 59 + this.getIndex();
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        result = result * 59 + Arrays.hashCode(this.getMessageSignature());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<MessageSignature> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        Component $unsignedContent = this.getUnsignedContent();
        result = result * 59 + ($unsignedContent == null ? 43 : $unsignedContent.hashCode());
        ChatFilterType $filterMask = this.getFilterMask();
        result = result * 59 + ($filterMask == null ? 43 : ((Object)((Object)$filterMask)).hashCode());
        Holder<ChatType> $chatType = this.getChatType();
        result = result * 59 + ($chatType == null ? 43 : $chatType.hashCode());
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerChatPacket(globalIndex=" + this.getGlobalIndex() + ", sender=" + String.valueOf(this.getSender()) + ", index=" + this.getIndex() + ", messageSignature=" + Arrays.toString(this.getMessageSignature()) + ", content=" + this.getContent() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", lastSeenMessages=" + String.valueOf(this.getLastSeenMessages()) + ", unsignedContent=" + String.valueOf(this.getUnsignedContent()) + ", filterMask=" + String.valueOf((Object)this.getFilterMask()) + ", chatType=" + String.valueOf(this.getChatType()) + ", name=" + String.valueOf(this.getName()) + ", targetName=" + String.valueOf(this.getTargetName()) + ")";
    }

    public @NonNull ClientboundPlayerChatPacket withGlobalIndex(int globalIndex) {
        return this.globalIndex == globalIndex ? this : new ClientboundPlayerChatPacket(globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withSender(UUID sender) {
        return this.sender == sender ? this : new ClientboundPlayerChatPacket(this.globalIndex, sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withIndex(int index) {
        return this.index == index ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withMessageSignature(byte @Nullable [] messageSignature) {
        return this.messageSignature == messageSignature ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withContent(String content) {
        return this.content == content ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withLastSeenMessages(List<MessageSignature> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withUnsignedContent(@Nullable Component unsignedContent) {
        return this.unsignedContent == unsignedContent ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withFilterMask(ChatFilterType filterMask) {
        return this.filterMask == filterMask ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, filterMask, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withChatType(Holder<ChatType> chatType) {
        return this.chatType == chatType ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withName(Component name) {
        return this.name == name ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, name, this.targetName);
    }

    public @NonNull ClientboundPlayerChatPacket withTargetName(@Nullable Component targetName) {
        return this.targetName == targetName ? this : new ClientboundPlayerChatPacket(this.globalIndex, this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, targetName);
    }

    public ClientboundPlayerChatPacket(int globalIndex, UUID sender, int index, byte @Nullable [] messageSignature, String content, long timeStamp, long salt, List<MessageSignature> lastSeenMessages, @Nullable Component unsignedContent, ChatFilterType filterMask, Holder<ChatType> chatType, Component name, @Nullable Component targetName) {
        this.globalIndex = globalIndex;
        this.sender = sender;
        this.index = index;
        this.messageSignature = messageSignature;
        this.content = content;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.lastSeenMessages = lastSeenMessages;
        this.unsignedContent = unsignedContent;
        this.filterMask = filterMask;
        this.chatType = chatType;
        this.name = name;
        this.targetName = targetName;
    }
}

