/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;

public record ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern) {
    public static @NonNull ArmorTrimBuilder builder() {
        return new ArmorTrimBuilder();
    }

    public @NonNull ArmorTrimBuilder toBuilder() {
        return new ArmorTrimBuilder().material(this.material).pattern(this.pattern);
    }

    public static class ArmorTrimBuilder {
        private Holder<TrimMaterial> material;
        private Holder<TrimPattern> pattern;

        ArmorTrimBuilder() {
        }

        public @NonNull ArmorTrimBuilder material(Holder<TrimMaterial> material) {
            this.material = material;
            return this;
        }

        public @NonNull ArmorTrimBuilder pattern(Holder<TrimPattern> pattern) {
            this.pattern = pattern;
            return this;
        }

        public @NonNull ArmorTrim build() {
            return new ArmorTrim(this.material, this.pattern);
        }

        public @NonNull String toString() {
            return "ArmorTrim.ArmorTrimBuilder(material=" + String.valueOf(this.material) + ", pattern=" + String.valueOf(this.pattern) + ")";
        }
    }

    public record TrimPattern(Key assetId, Component description, boolean decal) {
        public static @NonNull TrimPatternBuilder builder() {
            return new TrimPatternBuilder();
        }

        public @NonNull TrimPatternBuilder toBuilder() {
            return new TrimPatternBuilder().assetId(this.assetId).description(this.description).decal(this.decal);
        }

        public static class TrimPatternBuilder {
            private Key assetId;
            private Component description;
            private boolean decal;

            TrimPatternBuilder() {
            }

            public @NonNull TrimPatternBuilder assetId(Key assetId) {
                this.assetId = assetId;
                return this;
            }

            public @NonNull TrimPatternBuilder description(Component description) {
                this.description = description;
                return this;
            }

            public @NonNull TrimPatternBuilder decal(boolean decal) {
                this.decal = decal;
                return this;
            }

            public @NonNull TrimPattern build() {
                return new TrimPattern(this.assetId, this.description, this.decal);
            }

            public @NonNull String toString() {
                return "ArmorTrim.TrimPattern.TrimPatternBuilder(assetId=" + String.valueOf(this.assetId) + ", description=" + String.valueOf(this.description) + ", decal=" + this.decal + ")";
            }
        }
    }

    public record TrimMaterial(String assetBase, Map<Key, String> assetOverrides, Component description) {
        public TrimMaterial(String assetBase, Map<Key, String> assetOverrides, Component description) {
            this.assetBase = assetBase;
            this.assetOverrides = Map.copyOf(assetOverrides);
            this.description = description;
        }

        public static @NonNull TrimMaterialBuilder builder() {
            return new TrimMaterialBuilder();
        }

        public @NonNull TrimMaterialBuilder toBuilder() {
            return new TrimMaterialBuilder().assetBase(this.assetBase).assetOverrides(this.assetOverrides).description(this.description);
        }

        public static class TrimMaterialBuilder {
            private String assetBase;
            private Map<Key, String> assetOverrides;
            private Component description;

            TrimMaterialBuilder() {
            }

            public @NonNull TrimMaterialBuilder assetBase(String assetBase) {
                this.assetBase = assetBase;
                return this;
            }

            public @NonNull TrimMaterialBuilder assetOverrides(Map<Key, String> assetOverrides) {
                this.assetOverrides = assetOverrides;
                return this;
            }

            public @NonNull TrimMaterialBuilder description(Component description) {
                this.description = description;
                return this;
            }

            public @NonNull TrimMaterial build() {
                return new TrimMaterial(this.assetBase, this.assetOverrides, this.description);
            }

            public @NonNull String toString() {
                return "ArmorTrim.TrimMaterial.TrimMaterialBuilder(assetBase=" + this.assetBase + ", assetOverrides=" + String.valueOf(this.assetOverrides) + ", description=" + String.valueOf(this.description) + ")";
            }
        }
    }
}

